% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/md-list.R
\name{md_task}
\alias{md_task}
\title{Markdown task list (extension)}
\usage{
md_task(x, check = NULL)
}
\arguments{
\item{x}{A character vector of task list items.}

\item{check}{A optional numeric vector of list elements which should be
checked off.}
}
\value{
A \code{glue} vector with length equal to \code{x}.
}
\description{
take a character vector and return a glue vector of valid bullet list items.
When printed together, these bullet list items create a bullet list. This
container block is rendered as the \verb{<ul>} HTML tag, with each element of the
vector creating a separate \verb{<li>} tag. On venues supporting GitHub Flavored
Markdown, this list will be specially rendered with the list item market
replaces with a \verb{<input type="checkbox">} HTML tag.
}
\details{
GFM enables the tasklist extension, where an additional processing step is
performed on list items.

A task list item is a list item where the first block in it is a paragraph
which begins with a task list item marker and at least one whitespace
character before any other content.

A task list item marker consists of an optional number of spaces, a left
bracket, either a whitespace character or the letter \code{x} in either
lowercase or uppercase, and then a right bracket.

When rendered, the task list item marker is replaced with a semantic checkbox
element; in an HTML output, this would be an \verb{<input type="checkbox">}
element.

If the character between the brackets is a whitespace character, the checkbox
is unchecked. Otherwise, the checkbox is checked.

This spec does not define how the checkbox elements are interacted with: in
practice, implementors are free to render the checkboxes as disabled or
inmutable elements, or they may dynamically handle dynamic interactions (i.e.
checking, unchecking) in the final rendered document.
}
\examples{
md_task(c("Wake up", "Eat Breakfast", "Brush Teeth"), check = c(1, 3))
}
\seealso{
Other container block functions: 
\code{\link{md_bullet}()},
\code{\link{md_list}()},
\code{\link{md_order}()},
\code{\link{md_quote}()}
}
\concept{container block functions}
