% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{rabbits}
\alias{rabbits}
\title{Age and Eye Lens Weight of Rabbits in Australia}
\format{
A data frame with 71 rows and 2 variables:
\describe{
  \item{age}{a numeric vector indicating the rabbit age, in days.}
  \item{wlens}{a numeric vector indicating the dry weight of eye lens, in milligrams.}
}
}
\usage{
data(rabbits)
}
\description{
The dry weight of the eye lens was measured for 71 free-living wild rabbits of known age. Eye
lens weight tends to vary much less with environmental conditions than does total body weight, and
therefore may be a much better indicator of age.
}
\examples{
data(rabbits)
dev.new()
with(rabbits,plot(age,wlens,xlab="Age (in days)",pch=16,col="blue",
                  ylab="Dry weight of eye lens (in milligrams)"))
}
\references{
Dudzinski M.L., Mykytowycz R. (1961) The eye lens as an indicator of age in
 the wild rabbit in Australia. \emph{CSIRO Wildlife Research}, 6, 156-159.

Ratkowsky D.A. (1983). \emph{Nonlinear Regression Modelling}. Marcel Dekker, New York.

Wei B.C. (1998). \emph{Exponential Family Nonlinear Models}. Springer, Singapore.
}
\keyword{datasets}
