% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geeglm.R
\name{dfbeta.glmgee}
\alias{dfbeta.glmgee}
\title{Dfbeta for Generalized Estimating Equations}
\usage{
\method{dfbeta}{glmgee}(model, coefs, identify, ...)
}
\arguments{
\item{model}{an object of class glmgee which is obtained from the fit of a generalized estimating equation.}

\item{coefs}{an (optional) character string which (partially) match with the names of some parameters in the linear predictor.}

\item{identify}{an (optional) integer indicating the number of clusters to identify on the plot of dfbeta. This is only appropriate if \code{coefs} is specified.}

\item{...}{further arguments passed to or from other methods. If \code{coefs} is specified then \code{...} may be used to include graphical parameters to customize the plot. For example,  \code{col}, \code{pch}, \code{cex}, \code{main}, \code{sub}, \code{xlab}, \code{ylab}.}
}
\value{
A matrix with so many rows as clusters in the sample and so many columns as parameters in the linear predictor. The \eqn{i}-th row of that matrix corresponds to the difference between the estimates of the parameters in the linear predictor using all clusters and the \emph{one-step approximation} of those estimates when the \emph{i}-th cluster is excluded from the dataset.
}
\description{
Produces an approximation, better known as the \emph{one-step approximation}, of the effect of deleting each cluster in turn on the estimates of the parameters in the linear predictor of a generalized estimating equation. This function also can produce a plot of those effects for a subset of the parameters in the linear predictor.
}
\details{
The \emph{one-step approximation} of the estimates of the parameters in the linear predictor of a GEE when the \emph{i}-th cluster is excluded from the dataset is given by the vector obtained as the result of the first iteration of the fitting algorithm of that GEE when it is performed using:  (1) a dataset in which the \emph{i}-th cluster is excluded; and (2) a starting value which is the solution to the same GEE but based on the dataset inluding all clusters.
}
\examples{
mod <- size ~ poly(days,4) + treat
fit <- glmgee(mod, id=tree, family=Gamma("log"), data=spruce, corstr="Exchangeable")
dfbs <- dfbeta(fit, coefs="treat" ,col="red", lty=1, lwd=1, col.lab="blue",
               col.axis="blue", col.main="black", family="mono", cex=0.8, main="Dfbeta")

# Calculation by hand of dfbeta for the tree labeled by "N1T01"
idtree <- "N1T01"
onestep <- glmgee(mod, id=tree, family=Gamma("log"), data=spruce, corstr="Exchangeable",
                  start=coef(fit), subset=c(tree!=idtree), maxit=1)
coef(fit)-coef(onestep)
dfbs[rownames(dfbs)==idtree,]

}
\references{
Pregibon D. (1981). Logistic regression diagnostics. \emph{The Annals of Statistics}, 9, 705-724.
}
