% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmmPen.R
\name{LambdaSeq}
\alias{LambdaSeq}
\title{Calculation of Penalty Parameter Sequence (Lambda Sequence)}
\usage{
LambdaSeq(
  X,
  y,
  family,
  offset = NULL,
  alpha = 1,
  lambda.min = NULL,
  nlambda = 10,
  penalty.factor = NULL
)
}
\arguments{
\item{X}{matrix of standardized fixed effects (see \code{std} function in \code{ncvreg} 
documenation). X should not include intercept.}

\item{y}{numeric vector of response values. If "survival" family, \code{y} are the event indicator
values (0 if censored, 1 if event)}

\item{family}{a description of the error distribution and link function to be used in the model. 
Currently, the \code{glmmPen} algorithm allows the Binomial ("binomial" or binomial()), 
Gaussian ("gaussian" or gaussian()), and Poisson ("poisson" or poisson()) families
with canonical links only. See \code{\link{phmmPen}} for variable selection within
proportional hazards mixed models for survival data.}

\item{offset}{numeric vector that can be used to specify an a priori known component 
to be included in the linear predictor during fitting. 
This should be \code{NULL} or a numeric vector of length equal to the number of observations}

\item{alpha}{Tuning parameter for the Mnet estimator which controls the relative contributions 
from the MCP/SCAD/LASSO penalty and the ridge, or L2, penalty. \code{alpha=1} is equivalent to 
the MCP/SCAD/LASSO penalty, while \code{alpha=0} is equivalent to ridge regression. However,
\code{alpha=0} is not supported; \code{alpha} may be arbitrarily small, but not exactly zero}

\item{lambda.min}{numeric fraction between 0 and 1. The sequence of the lambda penalty parameters
ranges from the maximum lambda where all fixed and random effects are penalized to 0 and 
a minimum lambda value, which equals a small fraction of the maximum lambda. The parameter 
\code{lambda.min} specifies this fraction. Default value is set to \code{NULL}, which
automatically selects \code{lambda.min} to equal 0.01 when the number of observations is
greater than the number of fixed effects predictors and 0.05 otherwise.
Only used
if either \code{lambda0_seq} or \code{lambda1_seq} remain unspecified by the user
(one or both of these sequence arguments set to \code{NULL}) and, consequently, 
one or more default sequences need
to be calculated.}

\item{nlambda}{positive integer specifying number of penalty parameters (lambda) with 
which to fit a model.}

\item{penalty.factor}{an optional numeric vector equal to the \code{fixef_noPen} argument
in \code{\link{glmmPen}}}
}
\value{
numeric sequence of penalty parameters of length \code{nlambda} ranging from the
minimum penalty parameter (first element) equal to fraction \code{lambda.min} multiplied by the 
maximum penalty parameter to the maximum penalty parameter (last element)
}
\description{
Calculates the sequence of penalty parameters used in the model selection procedure.
This function calls functions from package \code{ncvreg}.
}
