% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmm.hp.r
\name{glmm.hp}
\alias{glmm.hp}
\title{Hierarchical Partitioning of Marginal R2 for Generalized Mixed-Effect Models}
\usage{
glmm.hp(mod, commonality = FALSE)
}
\arguments{
\item{mod}{Fitted lme4 or nlme model objects.}

\item{commonality}{Logical; If TRUE, the result of commonality analysis (2^N-1 fractions for N predictors) is shown, the default is FALSE.}
}
\value{
\item{Total.Marginal.R2}{The marginal R2 (fixed effect) for the full model.}

\item{commonality}{If commonality=TRUE, a matrix containing the value and percentage of all commonality (2^N-1 for N predictors).}

\item{Hier.part}{A matrix containing unique, average shared, individual effects and percentage of individual effects towards total marginal R2 for each predictor.}
}
\description{
Hierarchical Partitioning of Marginal R2 for Generalized Mixed-Effect Models
}
\details{
This function conducts commonality analysis and hierarchical partitioning to calculate the unique, average shared (referred as to "common") and individual contributions of each predictor (or matrix) towards marginal R2 for Generalized Mixed-effect Model. The marginal R2 can be calculated by r.squaredGLMM in MuMIn package.
Commonality analysis should be conducted before hierarchical partitioning. The former emphasizes unique and common variation among predictors, the latter emphasizes the overall importance of each predictor. This function simultaneously implements commonality analysis and hierarchical partitioning for marginal R2 without limiting in the number of predictors.
}
\examples{
library(MuMIn)
library(lme4)
mod1 <- lmer(Sepal.Length ~ Petal.Length + Petal.Width +(1 | Species), data = iris)
r.squaredGLMM(mod1)
glmm.hp(mod1)
plot(glmm.hp(mod1))
}
\references{
\itemize{
\item Lai J.,Zou Y., Zhang J.,Peres-Neto P.(2022) Generalizing hierarchical and variation partitioning in multiple regression and canonical analyses using the rdacca.hp R package.Methods in Ecology and Evolution,<DOI:10.1111/2041-210X.13800>
\item Chevan, A. & Sutherland, M. (1991). Hierarchical partitioning. American Statistician, 45, 90-96. doi:10.1080/00031305.1991.10475776
\item Nimon, K., Oswald, F.L. & Roberts, J.K. (2013). Yhat: Interpreting regression effects. R package version 2.0.0.
\item Nakagawa, S., & Schielzeth, H. (2013). A general and simple method for obtaining R2 from generalized linear mixed-effects models. Methods in Ecology and Evolution, 4(2), 133-142.
\item Nakagawa, S., Johnson, P. C., & Schielzeth, H. (2017). The coefficient of determination R2 and intra-class correlation coefficient from generalized linear mixed-effects models revisited and expanded. Journal of the Royal Society Interface, 14(134), 20170213.
}
}
\author{
{Jiangshan Lai} \email{lai@ibcas.ac.cn}

{Kim Nimon} \email{kim.nimon@gmail.com}
}
