% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/credential.r
\docType{methods}
\name{cred_env}
\alias{cred_env}
\alias{cred_env,character,character-method}
\title{Create a new environmental credential object}
\usage{
cred_env(username, password)

\S4method{cred_env}{character,character}(username, password)
}
\arguments{
\item{username}{The name of the environmental variable that holds
the username for the authentication.}

\item{password}{The name of the environmental variable that holds
the password for the authentication.}
}
\value{
A S4 \code{cred_env} object
}
\description{
Create a new environmental credential object
}
\examples{
\dontrun{
## Create an environmental credential object for the username and
## and a personal access token (PAT).
cred <- cred_env("GITHUB_USER", "GITHUB_PAT")
repo <- repository("git2r")
push(repo, credentials = cred)
}
}
\keyword{methods}

