% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tree.r
\docType{methods}
\name{show,git_tree-method}
\alias{show,git_tree-method}
\alias{show,git_tree-methods}
\title{Brief summary of tree}
\usage{
\S4method{show}{git_tree}(object)
}
\arguments{
\item{object}{The tree \code{object}}
}
\value{
None (invisible 'NULL').
}
\description{
Brief summary of tree
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a user and commit a file
config(repo, user.name="Alice", user.email="alice@example.org")
writeLines("Hello world!", file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")

## Brief summary of the tree in the repository
tree(commits(repo)[[1]])
}
}
\keyword{methods}

