% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco_get_airports.R
\name{gisco_get_airports}
\alias{gisco_get_airports}
\alias{gisco_get_ports}
\title{Get location of airports and ports from GISCO API}
\source{
\url{https://ec.europa.eu/eurostat/web/gisco/geodata/reference-data/transport-networks}
}
\usage{
gisco_get_airports(year = "2013", country = NULL)

gisco_get_ports(year = "2013")
}
\arguments{
\item{year}{Year of reference.}

\item{country}{Optional. A character vector of country codes. It could be
either a vector of country names, a vector of ISO3 country codes or a
vector of Eurostat country codes. Mixed types (as \code{c("Turkey","US","FRA")})
would not work. See also \code{\link[countrycode:countrycode]{countrycode::countrycode()}}.}
}
\value{
A \code{POINT} object on EPSG:4326.
}
\description{
Loads a \code{sf} object from GISCO API or your local library.
}
\section{Years available}{
\itemize{
\item \strong{\code{gisco_get_airports}}:  "2006" and "2013"
\item \strong{\code{gisco_get_ports}}: "2009" and "2013"
}

Ports 2009 contains worldwide information, the rest of datasets refer
to Europe. All shapefiles provided in EPSG:4326
}

\examples{
\donttest{
library(sf)

NL <- gisco_get_countries(country = "NL")
AirP_NL <- gisco_get_airports(country = "NL")

Ports <- gisco_get_ports()
# Intersect with NL
PortsNL <- st_intersection(Ports, NL)

# Bind
PortsNL_bind <- st_as_sf(type = "Port", st_geometry(PortsNL))
AirP_NL_bind <- st_as_sf(type = "Airport", st_geometry(AirP_NL))

Full <- rbind(AirP_NL_bind, PortsNL_bind)

library(ggplot2)

ggplot(NL) +
  geom_sf(fill = "wheat") +
  geom_sf(data = Full, aes(shape = type, color = type)) +
  labs(
    title = "Trasport network on the Netherlands",
    shape = NULL,
    color = NULL,
    caption = gisco_attributions()
  )
}

}
\seealso{
Other infrastructure: 
\code{\link{gisco_get_healthcare}()}
}
\author{
dieghernan, \url{https://github.com/dieghernan/}
}
\concept{infrastructure}
