% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prune.paths.R
\name{prune.paths}
\alias{prune.paths}
\title{Prunes paths. Ties together lowest.z and return.zs functions.}
\usage{
prune.paths(
  base_syntax,
  fixed_syntax,
  add_syntax,
  data_list,
  n_paths,
  n_subj,
  prop_cutoff,
  elig_paths,
  subgroup_stage = FALSE,
  test_cutoff
)
}
\arguments{
\item{base_syntax}{A character vector containing syntax that never changes.}

\item{fixed_syntax}{A character vector containing syntax that does not change
in a given stage of pruning.}

\item{add_syntax}{A character vector containing the syntax that is allowed
to change in a given stage of pruning.}

\item{data_list}{A list of datasets to be used in a given stage of the 
search. Varies based on group, subgroup, or individual-level stage.}

\item{n_paths}{The number of paths that are eligible for pruning. Equal
to the number of paths in add_syntax.}

\item{n_subj}{The number of subjects in a given stage of the search. If
in the group stage, n_subj equals the number of subjects. If in the subgroup
stage, n_subj equals the number of individuals in a given subgroup. At the 
individual stage, n_subj = 1.}

\item{prop_cutoff}{The proportion of individuals for whom a path must be
nonsignificant in order for it to be dropped from the models. NULL if used 
at the individual-level.}

\item{elig_paths}{A character vector containing eligible paths that
gimme is allowed to drop from the model at a given stage.}

\item{subgroup_stage}{Logical. Only present in order to instruct gimme
what message to print to console using writeLines.}

\item{test_cutoff}{Z score cutoff for significance testing.}
}
\value{
Returns updated values of n_paths and add_syntax.
}
\description{
Prunes paths. Ties together lowest.z and return.zs functions.
}
\keyword{internal}
