% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fragment-class.R
\name{Fragment}
\alias{Fragment}
\title{Fragment}
\value{
a `Fragment` class (R6 class)
}
\description{
ghql fragment class
}
\examples{
# make a fragment class
frag <- Fragment$new()

# define a fragment
frag$fragment('Watchers', '
  fragment on Repository {
    watchers(first: 3) {
      edges {
        node {
          name
       }
    }
  }
}')

# define another fragment
frag$fragment('Stargazers', '
  fragment on Repository {
    stargazers(first: 3) {
      edges {
        node {
          name
       }
    }
  }
}')
frag
frag$fragments
frag$fragments$Watchers
frag$fragments$Stargazers
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{fragments}}{(list) list of fragments}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-print}{\code{Fragment$print()}}
\item \href{#method-fragment}{\code{Fragment$fragment()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\subsection{Method \code{print()}}{
print method for the `Fragment` class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fragment$print(x, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{self}

\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fragment"></a>}}
\subsection{Method \code{fragment()}}{
create a fragment by name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fragment$fragment(name, x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{(character) fragment name}

\item{\code{x}}{(character) the fragment}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
nothing returned; sets fragments internally
}
}
}
