% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/theme-map.R
\name{theme_map}
\alias{theme_map}
\title{Clean theme for maps}
\usage{
theme_map(base_size = 9, base_family = "")
}
\arguments{
\item{base_size}{base font size}

\item{base_family}{base font family}
}
\description{
A clean theme that is good for displaying maps from \code{\link{geom_map}}.
}
\examples{
library('maps')
us <- fortify(map_data('state'), region = 'region')
gg <-
 (ggplot()
  + geom_map(data  =  us, map = us,
             aes(x = long, y = lat, map_id = region, group = group),
             fill = 'white', color = 'black', size = 0.25)
  + coord_map('albers', lat0 = 39, lat1 = 45)
  + theme_map()
  )
gg
}

