% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_grouped_functions.R
\name{grouped_list}
\alias{grouped_list}
\title{Split dataframe into a list by grouping variable.}
\usage{
grouped_list(data, grouping.var = NULL)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{grouping.var}{A single grouping variable (can be entered either as a
bare name \code{x} or as a string \code{"x"}).}
}
\description{
This function splits the dataframe into a list, with the length
of the list equal to the factor levels of the grouping variable. Each
element of the list will be a tibble.
}
\examples{
ggstatsplot:::grouped_list(data = ggplot2::msleep, grouping.var = vore)
}
\keyword{internal}
