% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouped_ggbetweenstats.R
\name{grouped_ggbetweenstats}
\alias{grouped_ggbetweenstats}
\title{Violin plots for group or condition comparisons in between-subjects
designs repeated across all levels of a grouping variable.}
\usage{
grouped_ggbetweenstats(data, x, y, grouping.var, title.prefix = NULL,
  plot.type = "boxviolin", type = "parametric",
  pairwise.comparisons = FALSE, pairwise.annotation = "asterisk",
  pairwise.display = "significant", p.adjust.method = "holm",
  effsize.type = "unbiased", partial = TRUE,
  effsize.noncentral = TRUE, bf.prior = 0.707, bf.message = TRUE,
  results.subtitle = TRUE, xlab = NULL, ylab = NULL,
  subtitle = NULL, stat.title = NULL, caption = NULL,
  sample.size.label = TRUE, k = 2, var.equal = FALSE,
  conf.level = 0.95, nboot = 100, tr = 0.1, sort = "none",
  sort.fun = mean, axes.range.restrict = FALSE, mean.label.size = 3,
  mean.label.fontface = "bold", mean.label.color = "black",
  notch = FALSE, notchwidth = 0.5, linetype = "solid",
  outlier.tagging = FALSE, outlier.label = NULL,
  outlier.label.color = "black", outlier.color = "black",
  outlier.shape = 19, outlier.coef = 1.5, mean.plotting = TRUE,
  mean.ci = FALSE, mean.size = 5, mean.color = "darkred",
  point.jitter.width = NULL, point.jitter.height = 0,
  point.dodge.width = 0.6, ggtheme = ggplot2::theme_bw(),
  ggstatsplot.layer = TRUE, package = "RColorBrewer",
  palette = "Dark2", direction = 1, ggplot.component = NULL,
  return = "plot", messages = TRUE, ...)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{The grouping variable from the dataframe \code{data}.}

\item{y}{The response (a.k.a. outcome or dependent) variable from the
dataframe \code{data}.}

\item{grouping.var}{A single grouping variable (can be entered either as a
bare name \code{x} or as a string \code{"x"}).}

\item{title.prefix}{Character string specifying the prefix text for the fixed
plot title (name of each factor level) (Default: \code{NULL}). If \code{NULL}, the
variable name entered for \code{grouping.var} will be used.}

\item{plot.type}{Character describing the \emph{type} of plot. Currently supported
plots are \code{"box"} (for pure boxplots), \code{"violin"} (for pure violin plots),
and \code{"boxviolin"} (for a combination of box and violin plots; default).}

\item{type}{Type of statistic expected (\code{"parametric"} or \code{"nonparametric"}
or \code{"robust"} or \code{"bayes"}).Corresponding abbreviations are also accepted:
\code{"p"} (for parametric), \code{"np"} (nonparametric), \code{"r"} (robust), or
\code{"bf"}resp.}

\item{pairwise.comparisons}{Logical that decides whether pairwise comparisons
are to be displayed. \strong{Only significant comparisons} will be shown by
default. (default: \code{FALSE}). To change this behavior, select appropriate
option with \code{pairwise.display} argument.}

\item{pairwise.annotation}{Character that decides the annotations to use for
pairwise comparisons. Either \code{"p.value"} or \code{"asterisk"} (default).}

\item{pairwise.display}{Decides which pairwise comparisons to display.
Available options are \code{"significant"} (abbreviation accepted: \code{"s"}) or
\code{"non-significant"} (abbreviation accepted: \code{"ns"}) or
\code{"everything"}/\code{"all"}. The default is \code{"significant"}. You can use this
argument to make sure that your plot is not uber-cluttered when you have
multiple groups being compared and scores of pairwise comparisons being
displayed.}

\item{p.adjust.method}{Adjustment method for \emph{p}-values for multiple
comparisons. Possible methods are: \code{"holm"} (default), \code{"hochberg"},
\code{"hommel"}, \code{"bonferroni"}, \code{"BH"}, \code{"BY"}, \code{"fdr"}, \code{"none"}.}

\item{effsize.type}{Type of effect size needed for \emph{parametric} tests. The
argument can be \code{"biased"} (\code{"d"} for Cohen's \emph{d} for \strong{t-test};
\code{"partial_eta"} for partial eta-squared for \strong{anova}) or \code{"unbiased"}
(\code{"g"} Hedge's \emph{g} for \strong{t-test}; \code{"partial_omega"} for partial
omega-squared for \strong{anova})).}

\item{partial}{Logical that decides if partial eta-squared or omega-squared
are returned (Default: \code{TRUE}). If \code{FALSE}, eta-squared or omega-squared
will be returned. Valid only for objects of class \code{lm}, \code{aov}, \code{anova}, or
\code{aovlist}.}

\item{effsize.noncentral}{Logical indicating whether to use non-central
\emph{t}-distributions for computing the confidence interval for Cohen's \emph{d}
or Hedge's \emph{g} (Default: \code{TRUE}).}

\item{bf.prior}{A number between \code{0.5} and \code{2} (default \code{0.707}), the prior
width to use in calculating Bayes factors.}

\item{bf.message}{Logical that decides whether to display Bayes Factor in
favor of the \emph{null} hypothesis. This argument is relevant only \strong{for
parametric test} (Default: \code{TRUE}).}

\item{results.subtitle}{Decides whether the results of statistical tests are
to be displayed as a subtitle (Default: \code{TRUE}). If set to \code{FALSE}, only
the plot will be returned.}

\item{xlab}{Labels for \code{x} and \code{y} axis variables. If \code{NULL} (default),
variable names for \code{x} and \code{y} will be used.}

\item{ylab}{Labels for \code{x} and \code{y} axis variables. If \code{NULL} (default),
variable names for \code{x} and \code{y} will be used.}

\item{subtitle}{The text for the plot subtitle. Will work only if
\code{results.subtitle = FALSE}.}

\item{stat.title}{A character describing the test being run, which will be
added as a prefix in the subtitle. The default is \code{NULL}. An example of a
\code{stat.title} argument will be something like \code{"Student's t-test: "}.}

\item{caption}{The text for the plot caption.}

\item{sample.size.label}{Logical that decides whether sample size information
should be displayed for each level of the grouping variable \code{x} (Default:
\code{TRUE}).}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{var.equal}{a logical variable indicating whether to treat the
    variances in the samples as equal.  If \code{TRUE}, then a simple F
    test for the equality of means in a one-way analysis of variance is
    performed.  If \code{FALSE}, an approximate method of Welch (1951)
    is used, which generalizes the commonly known 2-sample Welch test to
    the case of arbitrarily many samples.}

\item{conf.level}{Scalar between 0 and 1. If unspecified, the defaults return
\code{95\%} lower and upper confidence intervals (\code{0.95}).}

\item{nboot}{Number of bootstrap samples for computing confidence interval
for the effect size (Default: \code{100}).}

\item{tr}{Trim level for the mean when carrying out \code{robust} tests. If you
get error stating "Standard error cannot be computed because of Winsorized
variance of 0 (e.g., due to ties). Try to decrease the trimming level.",
try to play around with the value of \code{tr}, which is by default set to
\code{0.1}. Lowering the value might help.}

\item{sort}{If \code{"ascending"} (default), \code{x}-axis variable factor levels will
be sorted based on increasing values of \code{y}-axis variable. If
\code{"descending"}, the opposite. If \code{"none"}, no sorting will happen.}

\item{sort.fun}{The function used to sort (default: \code{mean}).}

\item{axes.range.restrict}{Logical that decides whether to restrict the axes
values ranges to \code{min} and \code{max} values of the axes variables (Default:
\code{FALSE}), only relevant for functions where axes variables are of numeric
type.}

\item{mean.label.size}{Aesthetics for
the label displaying mean. Defaults: \code{3}, \code{"bold"},\code{"black"}, respectively.}

\item{mean.label.fontface}{Aesthetics for
the label displaying mean. Defaults: \code{3}, \code{"bold"},\code{"black"}, respectively.}

\item{mean.label.color}{Aesthetics for
the label displaying mean. Defaults: \code{3}, \code{"bold"},\code{"black"}, respectively.}

\item{notch}{A logical. If \code{FALSE} (default), a standard box plot will be
displayed. If \code{TRUE}, a notched box plot will be used. Notches are used to
compare groups; if the notches of two boxes do not overlap, this suggests
that the medians are significantly different. In a notched box plot, the
notches extend \code{1.58 * IQR / sqrt(n)}. This gives a roughly \code{95\%}
confidence interval for comparing medians. IQR: Inter-Quartile Range.}

\item{notchwidth}{For a notched box plot, width of the notch relative to the
body (default \code{0.5}).}

\item{linetype}{Character strings (\code{"blank"}, \code{"solid"}, \code{"dashed"},
\code{"dotted"}, \code{"dotdash"}, \code{"longdash"}, and \code{"twodash"}) specifying the type
of line to draw box plots (Default: \code{"solid"}). Alternatively, the numbers
\code{0} to \code{6} can be used (\code{0} for "blank", \code{1} for "solid", etc.).}

\item{outlier.tagging}{Decides whether outliers should be tagged (Default:
\code{FALSE}).}

\item{outlier.label}{Label to put on the outliers that have been tagged.}

\item{outlier.label.color}{Color for the label to to put on the outliers that
have been tagged (Default: \code{"black"}).}

\item{outlier.color}{Default aesthetics for outliers (Default: \code{"black"}).}

\item{outlier.shape}{Hiding the outliers can be achieved by setting
outlier.shape = NA. Importantly, this does not remove the outliers,
it only hides them, so the range calculated for the y-axis will be
the same with outliers shown and outliers hidden.}

\item{outlier.coef}{Coefficient for outlier detection using Tukey's method.
With Tukey's method, outliers are below (1st Quartile) or above (3rd
Quartile) \code{outlier.coef} times the Inter-Quartile Range (IQR) (Default:
\code{1.5}).}

\item{mean.plotting}{Logical that decides whether mean is to be highlighted
and its value to be displayed (Default: \code{TRUE}).}

\item{mean.ci}{Logical that decides whether 95% confidence interval for mean
is to be displayed (Default: \code{FALSE}).}

\item{mean.size}{Point size for the data point corresponding to mean
(Default: \code{5}).}

\item{mean.color}{Color for the data point corresponding to mean (Default:
\code{"darkred"}).}

\item{point.jitter.width}{Numeric specifying the degree of jitter in \code{x}
direction. Defaults to \code{40\%} of the resolution of the data.}

\item{point.jitter.height}{Numeric specifying the degree of jitter in \code{y}
direction. Defaults to \code{0.1}.}

\item{point.dodge.width}{Numeric specifying the amount to dodge in the \code{x}
direction. Defaults to \code{0.60}.}

\item{ggtheme}{A function, \code{ggplot2} theme name. Default value is
\code{ggplot2::theme_bw()}. Any of the \code{ggplot2} themes, or themes from
extension packages are allowed (e.g., \code{ggthemes::theme_fivethirtyeight()},
\code{hrbrthemes::theme_ipsum_ps()}, etc.).}

\item{ggstatsplot.layer}{Logical that decides whether \code{theme_ggstatsplot}
theme elements are to be displayed along with the selected \code{ggtheme}
(Default: \code{TRUE}).}

\item{package}{Name of package from which the palette is desired as string
or symbol.}

\item{palette}{If a character string (e.g., \code{"Set1"}), will use that named
palette. If a number, will index into the list of palettes of appropriate
type. Default palette is \code{"Dark2"}.}

\item{direction}{Either \code{1} or \code{-1}. If \code{-1} the palette will be reversed.}

\item{ggplot.component}{A \code{ggplot} component to be added to the plot prepared
by \code{ggstatsplot}. This argument is primarily helpful for \code{grouped_} variant
of the current function. Default is \code{NULL}. The argument should be entered
as a function. If the given function has an argument \code{axes.range.restrict}
and if it has been set to \code{TRUE}, the added ggplot component \emph{might} not
work as expected.}

\item{return}{Character that describes what is to be returned: can be
\code{"plot"} (default) or \code{"subtitle"} or \code{"caption"}. Setting this to
\code{"subtitle"} will return the expression containing statistical results,
which will be a \code{NULL} if you set \code{results.subtitle = FALSE}. Setting this
to \code{"caption"} will return the expression containing details about Bayes
Factor analysis, but valid only when \code{type = "p"} and \code{bf.message = TRUE},
otherwise this will return a \code{NULL}.}

\item{messages}{Decides whether messages references, notes, and warnings are
to be displayed (Default: \code{TRUE}).}

\item{...}{Arguments passed on to \code{combine_plots}
\describe{
  \item{title.text}{String or plotmath expression to be drawn as title for the
\emph{combined plot}.}
  \item{title.color}{Text color for title.}
  \item{title.size}{Point size of title text.}
  \item{title.vjust}{Vertical justification for title. Default = \code{0.5}
(centered on \code{y}). \code{0} = baseline at \code{y}, \code{1} = ascender at \code{y}.}
  \item{title.hjust}{Horizontal justification for title. Default = \code{0.5}
(centered on \code{x}). \code{0} = flush-left at x, \code{1} = flush-right.}
  \item{title.fontface}{The font face (\code{"plain"}, \code{"bold"} (default),
\code{"italic"}, \code{"bold.italic"}) for title.}
  \item{caption.text}{String or plotmath expression to be drawn as the caption
for the \emph{combined plot}.}
  \item{caption.color}{Text color for caption.}
  \item{caption.size}{Point size of title text.}
  \item{caption.vjust}{Vertical justification for caption. Default = \code{0.5}
(centered on y). \code{0} = baseline at y, \code{1} = ascender at y.}
  \item{caption.hjust}{Horizontal justification for caption. Default = \code{0.5}
(centered on x). \code{0} = flush-left at x, \code{1} = flush-right.}
  \item{caption.fontface}{The font face (\code{"plain"} (default), \code{"bold"},
\code{"italic"}, \code{"bold.italic"}) for caption.}
  \item{sub.text}{The label with which the \emph{combined plot} should be annotated.
Can be a plotmath expression.}
  \item{sub.color}{Text color for annotation label (Default: \code{"black"}).}
  \item{sub.size}{Point size of annotation text (Default: \code{12}).}
  \item{sub.x}{The x position of annotation label (Default: \code{0.5}).}
  \item{sub.y}{The y position of annotation label (Default: \code{0.5}).}
  \item{sub.hjust}{Horizontal justification for annotation label (Default:
\code{0.5}).}
  \item{sub.vjust}{Vertical justification for annotation label (Default:
\code{0.5}).}
  \item{sub.vpadding}{Vertical padding. The total vertical space added to the
label, given in grid units. By default, this is added equally above and
below the label. However, by changing the y and vjust parameters, this can
be changed (Default: \code{grid::unit(1, "lines")}).}
  \item{sub.fontface}{The font face (\code{"plain"} (default), \code{"bold"}, \code{"italic"},
\code{"bold.italic"}) for the annotation label.}
  \item{sub.angle}{Angle at which annotation label is to be drawn (Default:
\code{0}).}
  \item{sub.lineheight}{Line height of annotation label.}
  \item{title.caption.rel.heights}{Numerical vector of relative columns heights
while combining (title, plot, caption).}
  \item{title.rel.heights}{Numerical vector of relative columns heights while
combining (title, plot).}
  \item{caption.rel.heights}{Numerical vector of relative columns heights while
combining (plot, caption).}
}}
}
\description{
A combined plot of comparison plot created for levels of a
grouping variable.
}
\details{
For parametric tests, Welch's ANOVA/\emph{t}-test are used as a default (i.e.,
\code{var.equal = FALSE}).
References:
\itemize{
\item ANOVA: Delacre, Leys, Mora, & Lakens, \emph{PsyArXiv}, 2018
\item \emph{t}-test: Delacre, Lakens, & Leys,
\emph{International Review of Social Psychology}, 2017
}

If robust tests are selected, following tests are used is .
\itemize{
\item ANOVA: one-way ANOVA on trimmed means (see \code{?WRS2::t1way})
\item \emph{t}-test: Yuen's test for trimmed means (see \code{?WRS2::yuen})
}

For more about how the effect size measures (for nonparametric tests) and
their confidence intervals are computed, see \code{?rcompanion::wilcoxonR}.

For repeated measures designs, use \code{ggwithinstats}.
}
\examples{

# to get reproducible results from bootstrapping
set.seed(123)

# the most basic function call
ggstatsplot::grouped_ggbetweenstats(
  data = dplyr::filter(ggplot2::mpg, drv != "4"),
  x = year,
  y = hwy,
  grouping.var = drv,
  conf.level = 0.99
)
\donttest{
# modifying individual plots using `ggplot.component` argument
ggstatsplot::grouped_ggbetweenstats(
  data = dplyr::filter(
    ggstatsplot::movies_long,
    genre \%in\% c("Action", "Comedy"),
    mpaa \%in\% c("R", "PG")
  ),
  x = genre,
  y = rating,
  grouping.var = mpaa,
  results.subtitle = FALSE,
  ggplot.component = ggplot2::scale_y_continuous(breaks = seq(1, 9, 1)),
  messages = FALSE
)
}

}
\references{
\url{https://indrajeetpatil.github.io/ggstatsplot/articles/web_only/ggbetweenstats.html}
}
\seealso{
\code{\link{ggbetweenstats}}, \code{\link{ggwithinstats}},
\code{\link{grouped_ggwithinstats}}
}
\author{
Indrajeet Patil, Chuck Powell
}
