% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggscatterstats.R
\name{ggscatterstats}
\alias{ggscatterstats}
\title{scatterplot with ggMarginals}
\arguments{
\item{data}{Dataframe from which variables specified are preferentially to be
taken.}

\item{x}{A vector containing the explanatory variable.}

\item{y}{The response - a vector of length the number of rows of \code{x}.}

\item{xlab}{Label for \code{x} axis variable.}

\item{ylab}{Label for \code{y} axis variable.}

\item{line.colour}{Colour for the regression line.}

\item{marginal}{Decides whether \code{ggExtra::ggMarginal()} plots will be
displayed; the default is \code{TRUE}.}

\item{marginal.type}{Type of marginal distribution to be plotted on the axes
("histogram", "boxplot", "density", "violin").}

\item{xfill}{Colour fill for x axis distibution (default: \code{orange}).}

\item{yfill}{Colour fill for y axis distribution (default: \code{green}).}

\item{type}{Type of association between paired samples required ("parametric:
Pearson's product moment correlation coefficient" or "nonparametric:
Spearman's rho" or "robust: Robust regression using an M estimator").
Corresponding abbreviations are also accepted: "p" (for
parametric/pearson's), "np" (nonparametric/spearman), "r" (robust), resp.}

\item{results.subtitle}{Decides whether the results of statistical tests are
to be displayed as subtitle.}

\item{intercept}{Decides whether "mean" or "median" or no intercept lines
(\code{NULL}) are to be plotted.}

\item{title}{The text for the plot title.}

\item{caption}{The text for the plot caption.}

\item{maxit}{Maximum number of iterations for robust linear regression or
bootstrap samples to compute Spearman's rho confidence intervals.}

\item{k}{Number of decimal places expected for results.}

\item{width.jitter}{Degree of jitter in \code{x} direction. Defaults to 40\% of
the resolution of the data.}

\item{height.jitter}{Degree of jitter in \code{y} direction. Defaults to 40\% of
the resolution of the data.}

\item{messages}{Decides whether messages references, notes, and warnings are
to be displayed (Default: \code{TRUE}).}
}
\description{
Scatterplots from `ggplot2`` combined with add marginal
histograms/boxplots/density plots with statistical details added as a
subtitle.
}
\note{
If you want to use \code{marginal.type = "violin"}, you will have to use
development version of \code{ggExtra}
}
\examples{

library(datasets)

# simple function call with the defaults
ggstatsplot::ggscatterstats(
data = datasets::mtcars,
x = wt,
y = mpg
)

# more detailed function call
ggstatsplot::ggscatterstats(
data = datasets::iris,
x = Petal.Length,
y = Sepal.Length,
intercept = 'median',
type = 'robust',
marginal.type = 'density'
)

}
\author{
Indrajeet Patil
}
