% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axis-utils-response-spct.R
\name{s.e.response_label}
\alias{s.e.response_label}
\alias{s.q.response_label}
\alias{s.e.action_label}
\alias{s.q.action_label}
\title{spectral response and action axis labels}
\usage{
s.e.response_label(
  unit.exponent = 0,
  format = getOption("photobiology.math", default = "R.expression"),
  label.text = axis_labels()[["s.e.response"]],
  scaled = FALSE,
  normalized = FALSE,
  axis.symbols = getOption("ggspectra.axis.symbols", default = TRUE)
)

s.q.response_label(
  unit.exponent = 0,
  format = getOption("photobiology.math", default = "R.expression"),
  label.text = axis_labels()[["s.q.response"]],
  scaled = FALSE,
  normalized = FALSE,
  axis.symbols = getOption("ggspectra.axis.symbols", default = TRUE)
)

s.e.action_label(
  unit.exponent = 0,
  format = getOption("photobiology.math", default = "R.expression"),
  label.text = axis_labels()[["s.e.action"]],
  scaled = FALSE,
  normalized = FALSE,
  axis.symbols = getOption("ggspectra.axis.symbols", default = TRUE)
)

s.q.action_label(
  unit.exponent = 0,
  format = getOption("photobiology.math", default = "R.expression"),
  label.text = axis_labels()[["s.q.action"]],
  scaled = FALSE,
  normalized = FALSE,
  axis.symbols = getOption("ggspectra.axis.symbols", default = TRUE)
)
}
\arguments{
\item{unit.exponent}{integer}

\item{format}{character string, "R", "R.expression", "R.character", or
"LaTeX".}

\item{label.text}{character Textual portion of the labels.}

\item{scaled}{logical If \code{TRUE} relative units are assumed.}

\item{normalized}{logical (\code{FALSE}) or numeric Normalization wavelength
in manometers (nm).}

\item{axis.symbols}{logical If \code{TRUE} symbols of the quantities are
added to the \code{name}. Supported only by \code{format = "R.expression"}.}
}
\value{
a character string or an R expression.
}
\description{
Generate axis labels for response or action spectra in SI units,
using SI scale factors. Output can be selected as character, expression (R
default devices) or LaTeX (for tikz device).
}
\examples{

s.e.response_label()
s.e.response_label(format = "R.expression")
s.e.response_label(format = "R.character")
s.e.response_label(format = "LaTeX")
s.e.response_label(unit.exponent = 3, format = "R.character")
s.q.response_label(format = "R.character")
s.e.action_label(format = "R.character")
s.q.action_label(format = "R.character")
s.e.response_label(scaled = TRUE)
s.e.response_label(scaled = TRUE, format = "R.character")
s.e.response_label(scaled = TRUE, format = "LaTeX")
s.e.response_label(normalized = 300)
s.e.response_label(normalized = 300, format = "R.character")
s.e.response_label(normalized = 300, format = "LaTeX")
s.q.response_label(scaled = TRUE)
s.q.response_label(scaled = TRUE, format = "R.character")
s.q.response_label(scaled = TRUE, format = "LaTeX")
s.q.response_label(normalized = 300)
s.q.response_label(normalized = 300, format = "R.character")
s.q.response_label(normalized = 300, format = "LaTeX")

}
