% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/x13-seasonal.R
\name{stat_seas}
\alias{stat_seas}
\title{X13 seasonal adjustment Stat}
\usage{
stat_seas(mapping = NULL, data = NULL, geom = "line",
  position = "identity", show.legend = NA, inherit.aes = TRUE, start,
  frequency, x13_params = NULL, ...)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link{aes}} or \code{\link{aes_string}}. Only needs to be set
at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{position}{The position adjustment to use for overlapping points
on this layer}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{start}{The starting point for the time series, in a format suitable for \code{ts()}}

\item{frequency}{The frequency for the time series}

\item{x13_params}{a list of other parameters for \code{seas}}

\item{...}{other arguments for the geom}
}
\description{
Conducts X13-SEATS-ARIMA seasonal adjustment on the fly for ggplot2
}
\examples{
ap_df <- data.frame(
      x = as.numeric(time(AirPassengers)),
      y = as.numeric(AirPassengers)
   )

# SEATS with defaults
ggplot(ap_df, aes(x = x, y = y)) +
   stat_seas(start = c(1949, 1), frequency = 12)
   
# X11 with no outlier treatment
ggplot(ap_df, aes(x = x, y = y)) +
  stat_seas(start = c(1949, 1), frequency = 12, x13_params = list(x11 = "", outlier = NULL))
   
ggplot(ldeaths_df, aes(x = YearMon, y = deaths, colour = sex)) +
  geom_point() +
  facet_wrap(~sex) +
  stat_seas(start = c(1974, 1), frequency = 12) +
  ggtitle("Seasonally adjusted lung deaths")
}
\seealso{
\code{\link{seas}}

Other time.series.stats.for.ggplot2: \code{\link{stat_decomp}},
  \code{\link{stat_stl}}
}

