% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/two_scatter.R
\name{two_scatter}
\alias{two_scatter}
\title{Two Scatter Plot Plot for Cox Regression}
\usage{
two_scatter(data, time, event, code.0 = "Alive", code.1 = "Dead",
  code.highrisk = "High", code.lowrisk = "Low", cutoff.show = TRUE,
  cutoff.value = "median", cutoff.x, cutoff.y, cutoff.label,
  title.A.ylab = "Risk Score", title.B.ylab = "Survival Time",
  title.xlab = "Rank", title.A.legend = "Risk Group",
  title.B.legend = "Status", size.AB = 1.5, size.ylab.title = 14,
  size.xlab.title = 14, size.Atext = 11, size.Btext = 11,
  size.xtext = 11, size.xyticks = 0.5, size.xyline = 0.5,
  size.points = 2, size.dashline = 1, size.cutoff = 5,
  size.legendtitle = 13, size.legendtext = 12, color.A = c(low =
  "blue", high = "red"), color.B = c(code.0 = "blue", code.1 = "red"),
  vjust.A.ylab = 1, vjust.B.ylab = 2, family = "sans",
  expand.x = 3)
}
\arguments{
\item{data}{dataframe data}

\item{time}{numeric variable. Name for following time}

\item{event}{must be numeric variable. Name for event, which must be coded as 0 and 1}

\item{code.0}{string. Code for event 0. Default is 'Alive'}

\item{code.1}{string. Code for event 1. Default is 'Dead'}

\item{code.highrisk}{string. Code for highrisk in risk score. Default is 'High'}

\item{code.lowrisk}{string. Code for lowrisk in risk score. Default is 'Low'}

\item{cutoff.show}{logical, whether to show text for cutoff in figure A. Default is TRUE}

\item{cutoff.value}{string, which can be 'median', 'roc' or 'cutoff'. Even you can define it by yourself}

\item{cutoff.x}{numeric (optional), ordination x for cutoff text}

\item{cutoff.y}{numeric (optional), ordination y for cutoff text}

\item{cutoff.label}{(should be) string. Define cutoff label by yourself}

\item{title.A.ylab}{string, y-lab title for figure A. Default is 'Riskscore'}

\item{title.B.ylab}{string, y-lab title for figure B. Default is 'Survival Time'}

\item{title.xlab}{string, x-lab title for figure B. Default is 'Rank'}

\item{title.A.legend}{string, legend title for figure A. Default is 'Risk Group'}

\item{title.B.legend}{string, legend title for figure B. Default is 'Status'}

\item{size.AB}{numeric, size for ABC. Default is 1.5}

\item{size.ylab.title}{numeric, size for y-axis label title. Default is 14}

\item{size.xlab.title}{numeric, size for x-axis lab title. Default is 11}

\item{size.Atext}{numeric, size for y-axis text in figure A. Default is 11}

\item{size.Btext}{numeric, size for y-axis text in figure B. Default is 11}

\item{size.xtext}{numeric, size for x-axis text. Default is 11}

\item{size.xyticks}{numeric, size for y-axis ticks. Default is 0.5}

\item{size.xyline}{numeric, size for y-axis line. Default is 0.5}

\item{size.points}{numeric, size for scatter points. Default is 2}

\item{size.dashline}{numeric, size for dashline. Default is 1}

\item{size.cutoff}{numeric, size for cutoff text. Default is 5}

\item{size.legendtitle}{numeric, size for legend title. Default is 13}

\item{size.legendtext}{numeric, size for legend text. Default is 12}

\item{color.A}{color for figure A. Default is low = 'blue', high = 'red'}

\item{color.B}{color for figure B. Default is code.0 = 'blue', code.1 = 'red'}

\item{vjust.A.ylab}{numeric, vertical just for y-label in figure A. Default is 1}

\item{vjust.B.ylab}{numeric, vertical just for y-label in figure B. Default is 2}

\item{family}{family, default is sans}

\item{expand.x}{numeric, expand for x-axis}
}
\value{
A riskscore picture
}
\description{
Two Scatter Plot Plot for Cox Regression
}
\examples{
two_scatter(data=LIRI,time='time',event='status',
            cutoff.value = 'median',
            cutoff.x = 142,
            cutoff.y = -0.5)
\donttest{
#more detailed example
library(ggrisk)
#plot
two_scatter(data=LIRI,time='time',event='status')
#regulate cutoff
##hidden cutoff
two_scatter(data=LIRI,time='time',event='status',
            cutoff.show = FALSE)
two_scatter(data=LIRI,time='time',event='status',
            cutoff.value = 'median')
two_scatter(data=LIRI,time='time',event='status',
            cutoff.value = 'roc')
two_scatter(data=LIRI,time='time',event='status',
            cutoff.value = 'cutoff')
two_scatter(data=LIRI,time='time',event='status',
            cutoff.value = -1)
two_scatter(data=LIRI,time='time',event='status',
            cutoff.value = 'median',
            cutoff.x = 142,
            cutoff.y = -0.5)
#code for 0 and 1
two_scatter(data=LIRI,time='time',event='status',
            cutoff.value = 'median',
            cutoff.x = 142,
            cutoff.y = -0.5,
            code.0 = 'Still Alive',
            code.1 = 'Dead')
#code for high and low risk group
two_scatter(data=LIRI,time='time',event='status',
            cutoff.value = 'median',
            cutoff.x = 142,
            cutoff.y = -0.5,
            code.0 = 'Still Alive',
            code.1 = 'Dead',
            code.highrisk = 'High Group',
            code.lowrisk = 'Low Group')
#title for legend, x and y lab
two_scatter(data=LIRI,time='time',event='status',
            cutoff.value = 'median',
            cutoff.x = 142,
            cutoff.y = -0.5,
            code.0 = 'Still Alive',
            code.1 = 'Dead',
            code.highrisk = 'High Group',
            code.lowrisk = 'Low Group',
            title.A.legend = 'Riskscore',
            title.B.legend = 'Event Status',
            title.A.ylab = 'Riskscore',
            title.B.ylab = 'Survival Time(year)',
            title.xlab = 'This is rank')
#vertical just for y-axis lab
two_scatter(data=LIRI,time='time',event='status',
            cutoff.value = 'median',
            cutoff.x = 142,
            cutoff.y = -0.5,
            code.0 = 'Still Alive',
            code.1 = 'Dead',
            code.highrisk = 'High Group',
            code.lowrisk = 'Low Group',
            title.A.legend = 'Riskscore',
            title.B.legend = 'Event Status',
            title.A.ylab = 'Riskscore',
            title.B.ylab = 'Survival Time(year)',
            title.xlab = 'This is rank',
            vjust.A.ylab = 1,
            vjust.B.ylab = 3)
#size
two_scatter(data=LIRI,time='time',event='status',
            cutoff.value = 'median',
            cutoff.x = 142,
            cutoff.y = -0.5,
            code.0 = 'Still Alive',
            code.1 = 'Dead',
            code.highrisk = 'High Group',
            code.lowrisk = 'Low Group',
            title.A.legend = 'Riskscore',
            title.B.legend = 'Event Status',
            title.A.ylab = 'Riskscore',
            title.B.ylab = 'Survival Time(year)',
            title.xlab = 'This is rank',
            vjust.A.ylab = 1,
            vjust.B.ylab = 3,
            size.AB = 2,
            size.ylab.title = 14,
            size.xlab.title = 14,
            size.Atext = 12,
            size.Btext = 12,
            size.xtext = 12,
            size.xyticks = 0.5,
            size.xyline = 0.5,
            size.dashline = 1.5,
            size.points = 1,
            size.cutoff = 5,
            size.legendtitle = 14,
            size.legendtext = 13)
#color
two_scatter(data=LIRI,time='time',event='status',
            cutoff.value = 'median',
            cutoff.x = 142,
            cutoff.y = -0.5,
            code.0 = 'Still Alive',
            code.1 = 'Dead',
            code.highrisk = 'High Group',
            code.lowrisk = 'Low Group',
            title.A.legend = 'Riskscore',
            title.B.legend = 'Event Status',
            title.A.ylab = 'Riskscore',
            title.B.ylab = 'Survival Time(year)',
            title.xlab = 'This is rank',
            vjust.A.ylab = 1,
            vjust.B.ylab = 3,
            size.AB = 2,
            size.ylab.title = 14,
            size.xlab.title = 14,
            size.Atext = 12,
            size.Btext = 12,
            size.xtext = 12,
            size.xyticks = 0.5,
            size.xyline = 0.5,
            size.dashline = 1.5,
            size.points = 1,
            size.cutoff = 5,
            size.legendtitle = 14,
            size.legendtext = 13,
            color.A = c(low='green',high='red'),
            color.B = c(code.0='green',code.1='red'))
#famli and expand
two_scatter(data=LIRI,time='time',event='status',
            cutoff.value = 'median',
            cutoff.x = 142,
            cutoff.y = -0.5,
            code.0 = 'Still Alive',
            code.1 = 'Dead',
            code.highrisk = 'High Group',
            code.lowrisk = 'Low Group',
            title.A.legend = 'Riskscore',
            title.B.legend = 'Event Status',
            title.A.ylab = 'Riskscore',
            title.B.ylab = 'Survival Time(year)',
            title.xlab = 'This is rank',
            vjust.A.ylab = 1,
            vjust.B.ylab = 3,
            size.AB = 2,
            size.ylab.title = 14,
            size.xlab.title = 14,
            size.Atext = 12,
            size.Btext = 12,
            size.xtext = 12,
            size.xyticks = 0.5,
            size.xyline = 0.5,
            size.dashline = 1.5,
            size.points = 1,
            size.cutoff = 5,
            size.legendtitle = 14,
            size.legendtext = 13,
            color.A = c(low='green',high='red'),
            color.B = c(code.0='green',code.1='red'),
            family = 'sans', # sans for Arail, serif for Times New Roman
            expand.x=10)
}
}
