% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gghistogram.R
\name{gghistogram}
\alias{gghistogram}
\title{Histogram plot}
\usage{
gghistogram(data, x, y = "..count..", color = "black", fill = NA,
  palette = NULL, size = NULL, linetype = "solid", alpha = 0.5,
  bins = NULL, add = c("none", "mean", "median"),
  add.params = list(linetype = "dashed"), rug = FALSE,
  add_density = FALSE, ggtheme = theme_classic2(), ...)
}
\arguments{
\item{data}{a data frame}

\item{x}{variable to be drawn.}

\item{y}{one of "..density.." or "..count..".}

\item{color, fill}{histogram line color and fill color.}

\item{palette}{the color palette to be used for coloring or filling by
groups. Allowed values include "grey" for grey color palettes; brewer
palettes e.g. "RdBu", "Blues", ...; or custom color palette e.g. c("blue",
"red"); and scientific journal palettes from ggsci R package, e.g.: "npg", "aaas", "lancet", "jco",
"ucscgb", "uchicago", "simpsons" and "rickandmorty".}

\item{size}{Numeric value (e.g.: size = 1). change the size of points and outlines.}

\item{linetype}{line type. See \code{\link{show_line_types}}.}

\item{alpha}{numeric value specifying fill color transparency. Value should
be in [0, 1], where 0 is full transparency and 1 is no transparency.}

\item{bins}{Number of bins. Defaults to 30.}

\item{add}{allowed values are one of "mean" or "median" (for adding mean or
median line, respectively).}

\item{add.params}{parameters (color, size, linetype) for the argument 'add';
e.g.: add.params = list(color = "red").}

\item{rug}{logical value. If TRUE, add marginal rug.}

\item{add_density}{logical value. If TRUE, add density curves.}

\item{ggtheme}{function, ggplot2 theme name. Default value is theme_pubr().
Allowed values include ggplot2 official themes: theme_gray(), theme_bw(),
theme_minimal(), theme_classic(), theme_void(), ....}

\item{...}{other arguments to be passed to
\code{\link[ggplot2]{geom_histogram}} and \code{\link{ggpar}}.}
}
\description{
Create a histogram plot.
}
\details{
The plot can be easily customized using the function ggpar(). Read
  ?ggpar for changing: \itemize{ \item main title and axis labels: main,
  xlab, ylab \item axis limits: xlim, ylim (e.g.: ylim = c(0, 30)) \item axis
  scales: xscale, yscale (e.g.: yscale = "log2") \item color palettes:
  palette = "Dark2" or palette = c("gray", "blue", "red") \item legend title,
  labels and position: legend = "right" \item plot orientation : orientation
  = c("vertical", "horizontal", "reverse") }
}
\examples{
# Create some data format
set.seed(1234)
wdata = data.frame(
   sex = factor(rep(c("F", "M"), each=200)),
   weight = c(rnorm(200, 55), rnorm(200, 58)))

head(wdata, 4)

# Basic density plot
# Add mean line and marginal rug
gghistogram(wdata, x = "weight", fill = "lightgray",
   add = "mean", rug = TRUE)

# Change outline colors by groups ("sex")
# Use custom color palette
gghistogram(wdata, x = "weight",
   add = "mean", rug = TRUE,
   color = "sex", palette = c("#00AFBB", "#E7B800"))

# Change outline and fill colors by groups ("sex")
# Use custom color palette
gghistogram(wdata, x = "weight",
   add = "mean", rug = TRUE,
   color = "sex", fill = "sex",
   palette = c("#00AFBB", "#E7B800"))



# Combine histogram and density plots
gghistogram(wdata, x = "weight",
   add = "mean", rug = TRUE,
   fill = "sex", palette = c("#00AFBB", "#E7B800"),
   add_density = TRUE)


}
\seealso{
\code{\link{ggpar}}
}

