% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggpmisc.R
\docType{package}
\name{ggpmisc-package}
\alias{ggpmisc}
\alias{ggpmisc-package}
\title{Miscellaneous Extensions to 'ggplot2'}
\description{
Implements extensions to 'ggplot2' respecting the grammar of graphics
paradigm. Provides new stats to locate and tag peaks and valleys in 2D
plots, a stat to add a label by group with the equation of a polynomial
fitted with lm(), or R^2 or adjusted R^2 values for any model fitted with
function lm(). Provides a function for flexibly converting time series to
data frames suitable for plotting with ggplot(). In addition provides two
stats useful for diagnosing what data are passed to compute_group() and
compute_panel() functions.
}
\details{
The new facilities for cleanly defining new stats and geoms added to
ggplot2 in version 2.0.0 have made this package easy to code. However, this
means that this package requires version 2.0.0 or later of ggplot2.

The stats for peaks and valleys are coded so as to work correctly both with
numeric and POSIXct variables mapped to the x aesthetic. Special handling was
needed as text labels are generated from the data.
}
\note{
The signatures of \code{stat_peaks()} and \code{stat_valleys()} are
  identical to those of \code{stat_peaks} and \code{stat_valleys} from
  package \code{photobiology} but the variables returned are a subset as
  values related to light spectra are missing. Furthermore the stats from
  package \code{ggpmisc} work correctly when the x aesthetic uses a date or
  datetime scale, while those from package \code{photobiology} do not
  generate correct labels in this case.
}
\author{
Pedro J. Aphalo
}
\references{
\code{ggplot2} web site at \url{http://ggplot2.org/}\cr
\code{ggplot2} source code at \url{https://github.com/hadley/ggplot2}
}

