% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation.R
\name{annotate}
\alias{annotate}
\title{Create an annotation layer}
\usage{
annotate(
  geom,
  x = NULL,
  y = NULL,
  xmin = NULL,
  xmax = NULL,
  ymin = NULL,
  ymax = NULL,
  xend = NULL,
  yend = NULL,
  ...,
  na.rm = FALSE
)
}
\arguments{
\item{geom}{name of geom to use for annotation}

\item{x, y, xmin, ymin, xmax, ymax, xend, yend}{positioning aesthetics -
you must specify at least one of these.}

\item{...}{Other arguments passed on to \code{\link[=layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}
}
\description{
This function adds geoms to a plot, but unlike a typical geom function,
the properties of the geoms are not mapped from variables of a data frame,
but are instead passed in as vectors. This is useful for adding small annotations
(such as text labels) or if you have your data in vectors, and for some
reason don't want to put them in a data frame.
}
\details{
Note that all position aesthetics are scaled (i.e. they will expand the
limits of the plot so they are visible), but all other aesthetics are
set. This means that layers created with this function will never
affect the legend.
}
\section{Unsupported geoms}{

Due to their special nature, reference line geoms \code{\link[=geom_abline]{geom_abline()}},
\code{\link[=geom_hline]{geom_hline()}}, and \code{\link[=geom_vline]{geom_vline()}} can't be used with \code{annotate()}.
You can use these geoms directly for annotations.
}

\examples{
p <- ggplot(mtcars, aes(x = wt, y = mpg)) + geom_point()
p + annotate("text", x = 4, y = 25, label = "Some text")
p + annotate("text", x = 2:5, y = 25, label = "Some text")
p + annotate("rect", xmin = 3, xmax = 4.2, ymin = 12, ymax = 21,
  alpha = .2)
p + annotate("segment", x = 2.5, xend = 4, y = 15, yend = 25,
  colour = "blue")
p + annotate("pointrange", x = 3.5, y = 20, ymin = 12, ymax = 28,
  colour = "red", size = 2.5, linewidth = 1.5)

p + annotate("text", x = 2:3, y = 20:21, label = c("my label", "label 2"))

p + annotate("text", x = 4, y = 25, label = "italic(R) ^ 2 == 0.75",
  parse = TRUE)
p + annotate("text", x = 4, y = 25,
  label = "paste(italic(R) ^ 2, \" = .75\")", parse = TRUE)
}
