% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggs_histogram.R
\name{ggs_histogram}
\alias{ggs_histogram}
\title{Histograms of the paramters.}
\usage{
ggs_histogram(D, family = NA, bins = 30, greek = FALSE)
}
\arguments{
\item{D}{Data frame whith the simulations.}

\item{family}{Name of the family of parameters to plot, as given by a character vector or a regular expression. A family of parameters is considered to be any group of parameters with the same name but different numerical value between square brackets (as beta[1], beta[2], etc).}

\item{bins}{integer indicating the total number of bins in which to divide the histogram. Defaults to 30, which is the same as geom_histogram()}

\item{greek}{Logical value indicating whether parameter labels have to be parsed to get Greek letters. Defaults to false.}
}
\value{
A \code{ggplot} object.
}
\description{
Plot a histogram of each of the parameters. Histograms are plotted combining all chains for each parameter.
}
\examples{
data(linear)
ggs_histogram(ggs(s))
}
\references{
Fernández-i-Marín, Xavier (2016) ggmcmc: Analysis of MCMC Samples and Bayesian Inference. Journal of Statistical Software, 70(9), 1-20. doi:10.18637/jss.v070.i09
}
