% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate_interactive.R
\name{annotate_interactive}
\alias{annotate_interactive}
\title{interactive annotations}
\usage{
annotate_interactive(geom, x = NULL, y = NULL, xmin = NULL,
  xmax = NULL, ymin = NULL, ymax = NULL, xend = NULL,
  yend = NULL, ..., na.rm = FALSE)
}
\arguments{
\item{geom}{name of geom to use for annotation}

\item{x}{positioning aesthetics -
you must specify at least one of these.}

\item{y}{positioning aesthetics -
you must specify at least one of these.}

\item{xmin}{positioning aesthetics -
you must specify at least one of these.}

\item{xmax}{positioning aesthetics -
you must specify at least one of these.}

\item{ymin}{positioning aesthetics -
you must specify at least one of these.}

\item{ymax}{positioning aesthetics -
you must specify at least one of these.}

\item{xend}{positioning aesthetics -
you must specify at least one of these.}

\item{yend}{positioning aesthetics -
you must specify at least one of these.}

\item{...}{Other arguments passed on to \code{\link[=layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}
}
\description{
Create interactive annotations, similar to ggplot2 \code{\link[ggplot2]{annotate}}.
}
\examples{
library(ggplot2)
library(ggiraph)

gg <- ggplot(mtcars, aes(x = disp, y = qsec )) +
  geom_point(size=2) +
  annotate_interactive(
    "rect", xmin = 100, xmax = 400, fill = "red",
    data_id = "an_id", tooltip = "a tooltip",
    ymin = 18, ymax = 20, alpha = .5)

x <- girafe(ggobj = gg, width_svg = 5, height_svg = 4)
if( interactive() ) print(x)
}
\seealso{
\code{\link{ggiraph}}
}
