% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggiraph.R
\name{ggiraph}
\alias{ggiraph}
\title{create a ggiraph object}
\usage{
ggiraph(code, ggobj = NULL, pointsize = 12, width = 0.75, width_svg = 6,
  height_svg = 5, tooltip_extra_css, hover_css, tooltip_opacity = 0.9,
  tooltip_offx = 10, tooltip_offy = 0, tooltip_zindex = 999,
  zoom_max = 1, selection_type = "multiple", selected_css, dep_dir = NULL,
  use_widget_size, flexdashboard, ...)
}
\arguments{
\item{code}{Plotting code to execute}

\item{ggobj}{ggplot objet to print. argument \code{code} will
be ignored if this argument is supplied.}

\item{pointsize}{the default pointsize of plotted text in pixels, default to 12.}

\item{width}{widget width ratio (0 < width <= 1). Unused within shiny
applications or flexdashboard documents. See below.}

\item{width_svg, height_svg}{The width and height of the graphics region in inches.
The default values are 6 and 5 inches. This will define the aspect ratio of the
graphic as it will be used to define viewbox attribute of the SVG result.}

\item{tooltip_extra_css}{extra css (added to \code{position: absolute;pointer-events: none;})
used to customize tooltip area.}

\item{hover_css}{css to apply when mouse is hover and element with a data-id attribute.}

\item{tooltip_opacity}{tooltip opacity}

\item{tooltip_offx}{tooltip x offset}

\item{tooltip_offy}{tooltip y offset}

\item{tooltip_zindex}{tooltip css z-index, default to 999.}

\item{zoom_max}{maximum zoom factor}

\item{selection_type}{row selection mode ("single", "multiple", "none")
when widget is in a Shiny application.}

\item{selected_css}{css to apply when element is selected (shiny only).}

\item{dep_dir}{the path where the output files are stored. If \code{NULL},
the current path for temporary files is used.}

\item{use_widget_size}{deprecated}

\item{flexdashboard}{deprecated}

\item{...}{arguments passed on to \code{\link[rvg]{dsvg}}}
}
\description{
Create an interactive graphic to be used in a web browser.

Use \code{geom_zzz_interactive} to create interactive graphical elements.

Difference from original functions is that the following
aesthetics are understood: \code{tooltip}, \code{onclick}
and \code{data_id}.

Tooltips can be displayed when mouse is over graphical elements.

If id are associated with points, they get animated when mouse is
over and can be selected when used in shiny apps.

On click actions can be set with javascript instructions. This option
should not be used simultaneously with selections in Shiny
applications as both features are "on click" features.

When \code{zoom_max} is set, "zoom activate", "zoom desactivate" and
"zoom init" buttons are available in a toolbar.

When \code{selection} is set to multiple (in Shiny applications), lasso
selection and lasso anti-selections buttons are available in a toolbar.
}
\section{Widget sizing}{

ggiraph graphics are responsive, which mean, they will be resized
according to their container. There are two responsive behavior
implementation: one for Shiny applications and flexdashboard documents
and one for other documents (i.e. R markdown and \code{saveWidget}).

When a ggiraph graphic is in a Shiny application or in a flexdashboard
graphic will be resized according to the arguments \code{width} and
\code{height} of the function \code{ggiraphOutput}. Default
values are '100%' and '500px'. These arguments determine the
outer bounding box (and \code{width_svg} and \code{height_svg}
determines the proportions.

When a ggiraph graphic is in an R markdown document (producing an HTML
document), the graphic will be resized according to the argument \code{width} of the
function \code{ggiraph}. Its value is beeing used to define a relative
width of the graphic within its HTML container. Its height is automatically
adjusted regarding to the argument \code{width} and the ratio between
\code{width_svg} and \code{height_svg}.

If this behavior does not fit with your need, I recommand you to use
package widgetframe that wraps htmlwidgets inside a responsive iframe.
}

\examples{
# ggiraph simple example -------
library(ggplot2)

# create dataset
dataset = mtcars
dataset$carname = row.names(mtcars)

# plots
gg_point = ggplot(
  data = dataset,
  mapping = aes(x = wt, y = qsec, color = disp,
                tooltip = carname, data_id = carname) ) +
	geom_point_interactive() + theme_minimal()

ggiraph(ggobj = gg_point, width = .7 )
}
