% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_point_interactive.R
\name{geom_point_interactive}
\alias{geom_point_interactive}
\title{add points with tooltips or click actions or double click actions
for a scatterplot}
\usage{
geom_point_interactive(mapping = NULL, data = NULL, stat = "identity",
  position = "identity", na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{The aesthetic mapping, see \code{\link[ggplot2]{geom_point}}.}

\item{data}{A data frame, see \code{\link[ggplot2]{geom_point}}.}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string, see \code{\link[ggplot2]{geom_point}}.}

\item{position}{Postion adjustment, see \code{\link[ggplot2]{geom_point}}.}

\item{na.rm}{See \code{\link[ggplot2]{geom_point}}.}

\item{show.legend}{See \code{\link[ggplot2]{geom_point}}.}

\item{inherit.aes}{See \code{\link[ggplot2]{geom_point}}.}

\item{...}{other arguments passed on to layer. See \code{\link[ggplot2]{geom_point}}.}
}
\description{
The point_interactive geom is used to create interactive scatterplots, tooltips
can be displayed when mouse is over points, on click actions and double click actions can be
set with javascript instructions.
}
\examples{
# add interactive points to a ggplot -------
# create dataset
dataset = iris
dataset$tooltip = dataset$Species
dataset$clickjs = paste0("function() {alert('",dataset$Species, "')}" )

# plots
gg_point = ggplot(dataset, aes(x = Sepal.Length, y = Petal.Width,
		color = Species, tooltip = tooltip, onclick = clickjs) ) +
	geom_point_interactive()

ggiraph(code = {print(gg_point)})
}
\seealso{
\code{\link{ggiraph}}
}

