% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uses_dst.R
\name{uses_dst}
\alias{uses_dst}
\title{Test if datetime object potentially uses daylight saving time}
\usage{
uses_dst(x)
}
\arguments{
\item{x}{A datetime object.}
}
\value{
Returns a \code{logical} value indicating of the time zone
used by the datetime object potentially uses daylight saving time.
}
\description{
Function to check if a datetime object potentially uses daylight
saving time. It is not the same as \code{\link[lubridate:dst]{lubridate::dst()}}, which will
determine if daylight saving time is set for the requested date.
}
\examples{
uses_dst(as.POSIXct("2020-03-29 02:00:00 CET", tz = "CET"))
uses_dst(as.POSIXct("2020-03-29 02:00:00 UTC", tz = "UTC"))
}
\author{
Pepijn de Vries
}
