% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster.R
\name{with_raster}
\alias{with_raster}
\title{Convert a layer to a raster}
\usage{
with_raster(x, ...)
}
\arguments{
\item{x}{A ggplot2 layer object, a ggplot, a grob, or a character string
naming a filter}

\item{...}{Arguments to be passed on to methods. See
\link[=object_support]{the documentation of supported object} for a description of
object specific arguments.}
}
\value{
Depending on the input, either a \code{grob}, \code{Layer}, list of \code{Layer}s,
\code{guide}, or \code{element} object. Assume the output can be used in the same
context as the input.
}
\description{
This filter simply converts the given layer, grob, or ggplot to a raster and
inserts it back again. It is useful for vector graphics devices such as
svglite if a layer contains a huge amount of primitives that would make the
file slow to render. \code{as_reference(x, id)} is a shorthand for
\code{with_raster(x, id = id, include = FALSE)} that makes the intent of using
this grob or layer as only a filter reference clear.
}
\examples{
library(ggplot2)
ggplot(mtcars, aes(mpg, disp)) +
  with_raster(geom_point(data = mtcars, size = 3))

}
