% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blur.R
\name{with_blur}
\alias{with_blur}
\title{Apply a gaussian blur to your layer}
\usage{
with_blur(x, sigma = 0.5, stack = FALSE, ...)
}
\arguments{
\item{x}{A ggplot2 layer object, a ggplot, a grob, or a character string
naming a filter}

\item{sigma}{The standard deviation of the gaussian kernel. Increase it to
apply more blurring. If a numeric it will be interpreted as given in pixels.
If a unit object it will automatically be converted to pixels at rendering
time}

\item{stack}{Should the original layer be placed on top?}

\item{...}{Arguments to be passed on to methods. See
\link[=object_support]{the documentation of supported object} for a description of
object specific arguments.}
}
\value{
Depending on the input, either a \code{grob}, \code{Layer}, list of \code{Layer}s,
\code{guide}, or \code{element} object. Assume the output can be used in the same
context as the input.
}
\description{
This filter adds a blur to the provided ggplot layer. The amount of blur can
be controlled and the result can optionally be put underneath the original
layer.
}
\examples{
library(ggplot2)
ggplot(mtcars, aes(mpg, disp)) +
  with_blur(geom_point(data = mtcars, size = 3), sigma = 3)

}
\seealso{
Other blur filters: 
\code{\link{with_motion_blur}()},
\code{\link{with_variable_blur}()}
}
\concept{blur filters}
