% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify_stats.R
\name{fortify.acf}
\alias{fortify.acf}
\title{Convert \code{stats::acf} to \code{data.frame}}
\usage{
\method{fortify}{acf}(model, data = NULL, conf.int = TRUE,
  conf.int.value = 0.95, conf.int.type = "white", ...)
}
\arguments{
\item{model}{\code{stats::acf} instance}

\item{data}{original dataset, if needed}

\item{conf.int}{Logical flag indicating whether to attach confidence intervals}

\item{conf.int.value}{Coverage probability for confidence interval}

\item{conf.int.type}{Type of confidence interval, 'white' for white noise or 'ma' MA(k-1) model}

\item{...}{other arguments passed to methods}
}
\value{
data.frame
}
\description{
Convert \code{stats::acf} to \code{data.frame}
}
\examples{
fortify(stats::acf(AirPassengers))
fortify(stats::pacf(AirPassengers))
fortify(stats::ccf(AirPassengers, AirPassengers))

fortify(stats::acf(AirPassengers), conf.int = TRUE)
}

