% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gf_functions.R
\name{gf_qq}
\alias{gf_qq}
\alias{gf_qqline}
\alias{gf_qqstep}
\title{Formula interface to geom_qq()}
\usage{
gf_qq(object = NULL, gformula = NULL, data = NULL, ..., group,
  distribution = stats::qnorm, dparams = list(), xlab, ylab, title,
  subtitle, caption, geom = "point", stat = "qq",
  position = "identity", show.legend = NA, show.help = NULL,
  inherit = TRUE, environment = parent.frame())

gf_qqline(object = NULL, gformula = NULL, data = NULL, ..., group,
  distribution = stats::qnorm, dparams = list(), linetype = "dashed",
  alpha = 0.7, xlab, ylab, title, subtitle, caption, geom = "line",
  stat = "qqline", position = "identity", show.legend = NA,
  show.help = NULL, inherit = TRUE, environment = parent.frame())

gf_qqstep(object = NULL, gformula = NULL, data = NULL, ..., group,
  distribution = stats::qnorm, dparams = list(), xlab, ylab, title,
  subtitle, caption, geom = "step", stat = "qq",
  position = "identity", show.legend = NA, show.help = NULL,
  inherit = TRUE, environment = parent.frame())
}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions
of the chain.  Most users can safely ignore this argument.
See details and examples.}

\item{gformula}{A formula with shape \code{~ sample}. Facets can be
added using \code{|}.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{...}{Additional arguments.  Typically these are
(a) ggplot2 aesthetics to be set with \code{attribute = value},
(b) ggplot2 aesthetics to be mapped with \code{attribute = ~ expression}, or
(c) attributes of the layer as a whole, which are set with \code{attribute = value}.}

\item{group}{Used for grouping.}

\item{distribution}{Distribution function to use, if x not specified}

\item{dparams}{Additional parameters passed on to \code{distribution}
function.}

\item{xlab}{Label for x-axis. See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{ylab}{Label for y-axis. See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{title}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{subtitle}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{caption}{Title, sub-title, and caption for the plot.
See also \code{\link[=gf_labs]{gf_labs()}}.}

\item{geom}{Use to override the default connection between
\code{geom_histogram()}/\code{geom_freqpoly()} and \code{stat_bin()}.}

\item{stat}{Use to override the default connection between
\code{geom_histogram()}/\code{geom_freqpoly()} and \code{stat_bin()}.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{show.help}{If \code{TRUE}, display some minimal help.}

\item{inherit}{A logical indicating whether default attributes are inherited.}

\item{environment}{An environment in which to look for variables not found in \code{data}.}

\item{linetype}{A linetype (numeric or "dashed", "dotted", etc.) or a formula used
for mapping linetype.}

\item{alpha}{Opacity (0 = invisible, 1 = opaque).}
}
\value{
a gg object
}
\description{
\code{gf_qq()} an \code{gf_qqstep()} both create quantile-quantile plots. They
differ in how they display the qq-plot.
\code{gf_qq()} uses points and \code{gf_qqstep()} plots a step function
through these points.
}
\section{Specifying plot attributes}{


Positional attributes (a.k.a, aesthetics) are specified using the formula in \code{gformula}.
Setting and mapping of additional attributes can be done through the
use of additional arguments.
Attributes can be set can be set using arguments of the form \code{attribute = value} or
mapped using arguments of the form \code{attribute = ~ expression}.

In formulas of the form \code{A | B}, \code{B} will be used to form facets using
\code{\link[=facet_wrap]{facet_wrap()}} or \code{\link[=facet_grid]{facet_grid()}}.
This provides an alternative to
\code{\link[=gf_facet_wrap]{gf_facet_wrap()}} and
\code{\link[=gf_facet_grid]{gf_facet_grid()}} that is terser and may feel more familiar to users
of \pkg{lattice}.
}

\section{Evaluation}{


Evaluation of the \pkg{ggplot2} code occurs in the environment of \code{gformula}.
This will typically do the right thing when formulas are created on the fly, but might not
be the right thing if formulas created in one environment are used to create plots
in another.
}

\examples{
gf_qq(~ rnorm(100))
gf_qq(~ Sepal.Length | Species, data = iris) \%>\% gf_qqline()
gf_qq(~ Sepal.Length | Species, data = iris) \%>\% gf_qqline(tail = 0.10)
gf_qq(~Sepal.Length, color = ~Species, data = iris) \%>\%
  gf_qqstep(~Sepal.Length, color = ~Species, data = iris)
}
\seealso{
\code{\link[ggplot2:geom_qq]{ggplot2::geom_qq()}}
}
