% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_alpha_focus.R
\name{scale_alpha_focus}
\alias{scale_alpha_focus}
\title{scale_color_focus}
\usage{
scale_alpha_focus(focus_levels, alpha_focus = 1, alpha_other = 0.05)
}
\arguments{
\item{focus_levels}{character vector with levels to focus.}

\item{alpha_focus}{`alpha` for focused levels.}

\item{alpha_other}{`alpha` for other levels.}
}
\description{
Alpha scale that focus specific factor levels. This is an alternative use of \link{ggfocus} function that uses the usual grammar of graphics.
}
\examples{
 p <- ggplot(iris,aes(x = Petal.Length, y = Sepal.Length, alpha = Species)) + geom_point() +
  scale_alpha_focus(focus_levels = "versicolor")
 # Note this gives a warning because alpha doesn't always make sense with categorical variables.

}
