% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_prior}
\alias{plot_prior}
\alias{plot.prior}
\title{Plot prior distributions}
\usage{
plot_prior(i, prior, xlim = NA, natural = TRUE, npoint = 100,
  trans = NA, save = FALSE, ...)

\method{plot}{prior}(x, save = FALSE, ps = NULL, ...)
}
\arguments{
\item{i}{an integer or a character string indicating which parameter to plot}

\item{prior}{a prior object}

\item{xlim}{set the range of on x axis. This is usually the range for each
parameter.}

\item{natural}{default TRUE.}

\item{npoint}{default to plot 100}

\item{trans}{default NA. trans can be a scalar or vector.}

\item{save}{whether to save the data out}

\item{...}{other plotting arguments passing through dot dot dot.}

\item{x}{a prior object}

\item{ps}{true parameter vectors or matrix in the case of many observation
units}
}
\description{
\code{plot_prior} plots one member in a prior object. \code{plot.prior}
plots all members in a prior object.
}
\examples{
p.prior <- BuildPrior(
           dists = rep("tnorm", 7),
           p1    = c(a = 2,   v.f1 = 4,  v.f2 = 3,  z = 0.5, sv = 1,
                     sz = 0.3, t0 = 0.3),
           p2    = c(a = 0.5, v.f1 = .5, v.f2 = .5, z = 0.1, sv = .3,
                     sz = 0.1, t0 = 0.05),
           lower = c(0,-5, -5, 0, 0, 0, 0),
           upper = c(5, 7,  7, 1, 2, 1, 1))

plot_prior("a", p.prior)
plot_prior(2, p.prior)
plot(p.prior)
}
