% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling.R
\name{run}
\alias{run}
\alias{CheckConverged}
\title{Run model fits}
\usage{
run(samples, report = 100, ncore = 1, pm = 0, qm = 0, hpm = 0,
  hqm = 0, gammamult = 2.38, ngroup = 5, force = FALSE,
  sampler = "DE-MCMC", slice = FALSE)

CheckConverged(samples)
}
\arguments{
\item{samples}{a sample list generated by calling DMC's samples.dmc.}

\item{report}{how many iterations to return a report}

\item{ncore}{parallel core for run_many}

\item{pm}{probability of migration}

\item{qm}{probability of mutation}

\item{hpm}{probability of migration at the hyper level}

\item{hqm}{probability of mutation at the hyper level}

\item{gammamult}{a tuning parameter, affecting the size of jump}

\item{ngroup}{number of distributed groups}

\item{force}{set force to FALSE for turning off recalculation of PDA.
Set it  as an integer between 1 and 10, forcing to re-calculate new
likelihood, every e.g., 1, 2, 3 step.}

\item{sampler}{which sampler to run MCMC, "DE-MCMC" or "DGMC"}

\item{slice}{use for debugging blocked sampling}
}
\description{
This function fit a hierarchical or a fixed-effect model, using Bayeisan
sampling.  We use pMCMC, with a suite of DE-MCMC, DGMC, and simply,
crossover (i.e., DE-MC), mutation, or migration operators. Note that
the latter two operators essentially are random-walk Metroplolis, so they
will be very inefficient, if been applied alone, even with our fast C++
implementation.
}
