% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{censor}
\alias{censor}
\title{Censor missing values and RT outliers}
\usage{
censor(x, xlim = c(0, Inf))
}
\arguments{
\item{x}{a data frame}

\item{xlim}{the lower and upper censoring boundaries}
}
\description{
\code{censor} requests a data frame minimally with three columns, indicating
stimulus (S factor), response (R factor) and response time
(RT).
}
\examples{
model <- BuildModel(
        p.map     = list(a = "1", v = "1", z = "1", d = "1", t0 = "1",
                    sv = "1", sz = "1", st0 = "1"),
        constants = c(st0 = 0, d = 0, sz = 0, sv = 0),
        match.map = list(M = list(s1 = "r1", s2 = "r2")),
        factors   = list(S = c("s1", "s2")),
        responses = c("r1", "r2"),
        type      = "rd")
p.vector <- c(a = 1, v = 1, z = 0.5, t0 = .15)
dat <- simulate(model, 100, ps = p.vector)
dmi <- BuildDMI(dat, model)

## Trim off RTs below .05 and above 10 s
censored_data <- censor(dat, xlim = c(.05, 10))
}
