% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmc_sampling.R
\name{samples.dmc}
\alias{samples.dmc}
\title{Initialising a DMC samples}
\usage{
samples.dmc(nmc, p.prior = NULL, data = NULL, thin = 1, samples = NULL,
  theta1 = NULL, restart = TRUE, add = FALSE, remove = FALSE,
  start.prior = NULL, rp = 0.001, setting = NULL, verbose = FALSE)
}
\arguments{
\item{nmc}{the number of MCMC iterations.}

\item{p.prior}{prior parameter list}

\item{data}{a model data instance.}

\item{thin}{thinning length. Default is 1.}

\item{samples}{a DMC posterior sample}

\item{theta1}{a nChains x npar matrix}

\item{restart}{whether to restart a new samples}

\item{add}{whether to add more iterations on top of previous DMC sample}

\item{remove}{whether to remove some of the samples}

\item{start.prior}{a user indicated alternative prior parameter list}

\item{rp}{DE-MCMC tuning parameter. The user usually needs not set this
argument. Default 0.001}

\item{setting}{a list carrying thin, restart, add, remove, start.from,
start.prior, rp, and verbose setting. The user usually needs not set this
argument.}

\item{verbose}{whether to print debugging information}
}
\description{
A wrapper function for C++ \code{initialise_data}. \code{samples.dmc}
initialise a DMC sample for one participant. The user needs to minimally
enter three arguments: \code{nmc}, \code{p.prior} and \code{data} or
\code{nmc}, \code{p.prior} and \code{samples}. Note the current version
initialise only drift-diffusion model samples.
}
\details{
\emph{initialise_data} generates random samples based on the probability
functions listed in prior parameter list (ie p.prior). This sets up a MCMC
sample (ie samples). \emph{initialise_hyper} generates a samples
hierarchically based on hyper-prior and prior parameter lists (ie p.prior
and pp.prior). For initialising multiple participants, please use
\code{h.samples.dmc}.
}
\examples{
m1 <- model.dmc(
    p.map     = list(a="1",v="F",z="1",d="1",sz="1",sv="1", t0="1",st0="1"),
    constants = c(st0=0,d=0),
    match.map = list(M=list(s1="r1",s2="r2")),
    factors   = list(S=c("s1","s2"), F=c("f1", "f2")),
    responses = c("r1","r2"),
    type      = "rd")

## m1 is "dmc" class
class(m1)
## [1] "dmc"

pVec <- c(a=1, v.f1=1, v.f2=1.5, z=0.5, sz=0.25, sv=0.2,t0=.15)
dat  <- simulate(m1, nsim=1e2, p.vector=pVec)
str(dat)
## 'data.frame':	400 obs. of  4 variables:
## $ S : Factor w/ 2 levels "s1","s2": 1 1 1 1 1 1 1 1 1 1 ...
## $ F : Factor w/ 2 levels "f1","f2": 1 1 1 1 1 1 1 1 1 1 ...
## $ R : Factor w/ 2 levels "r1","r2": 1 1 1 2 1 1 1 1 2 1 ...
## $ RT: num  0.26 0.255 0.572 0.25 0.518 ...

## mdi1 is dmc as well as data.frame class
mdi1 <- data.model.dmc(dat, m1)
class(mdi1)
## [1] "dmc"        "data.frame"

p.prior <- prior.p.dmc(
   dists = rep("tnorm", 7),
   p1    = c(a=2,  v.f1=2.5, v.f2=1.25, z=.5, sz=.3, sv=1,  t0=.3),
   p2    = c(a=.5, v.f1=.5,  v.f2=.35,  z=.1, sz=.1, sv=.3, t0=.05),
   lower = c(0,-5, -5, 0, 0, 0, 0),
   upper = c(5, 7,  7, 2, 2, 2, 2))

## Set up a new DMC sample with 200 iteration. The default thinning length
## is 1
samples0 <- samples.dmc(nmc=50, p.prior=p.prior, data=mdi1)
samples0$nmc
## [1] 50

## Run a fixed-effect model with 5\% chance of using migration sampler
## samples0 <- run.dmc(samples0, p.migrate=.05)

## Add 200 more iteration on to sample0
samples1 <- samples.dmc(nmc=50, p.prior=p.prior, samples=samples0, add=TRUE)
## samples1$nmc
## [1] 100
}

