% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_pointinterval.R
\name{stat_pointinterval}
\alias{stat_pointinterval}
\title{Point summary + multiple uncertainty interval plots (ggplot stat)}
\usage{
stat_pointinterval(
  mapping = NULL,
  data = NULL,
  geom = "pointinterval",
  position = "identity",
  ...,
  orientation = NA,
  interval_function = NULL,
  interval_args = list(),
  point_interval = median_qi,
  .width = c(0.66, 0.95),
  show_slab = FALSE,
  na.rm = FALSE,
  show.legend = c(size = FALSE),
  inherit.aes = TRUE,
  .prob,
  fun.data,
  fun.args
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{Use to override the default connection between
\code{stat_slabinterval} and \code{\link[=geom_slabinterval]{geom_slabinterval()}}}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed to \code{\link[=layer]{layer()}}. They may also be arguments to the paired geom
(e.g., \code{\link[=geom_pointinterval]{geom_pointinterval()}})}

\item{orientation}{Whether this geom is drawn horizontally (\code{"horizontal"}) or
vertically (\code{"vertical"}). The default, \code{NA}, automatically detects the orientation based on how the
aesthetics are assigned, and should generally do an okay job at this. When horizontal (resp. vertical),
the geom uses the \code{y} (resp. \code{x}) aesthetic to identify different groups, then for each group uses
the \code{x} (resp. \code{y}) aesthetic and the \code{thickness} aesthetic to draw a function as an slab, and draws
points and intervals horizontally (resp. vertically) using the \code{xmin}, \code{x}, and \code{xmax} (resp.
\code{ymin}, \code{y}, and \code{ymax}) aesthetics. For compatibility with the base
ggplot naming scheme for \code{orientation}, \code{"x"} can be used as an alias for \code{"vertical"} and \code{"y"} as an alias for
\code{"horizontal"} (tidybayes had an \code{orientation} parameter before ggplot did, and I think the tidybayes naming
scheme is more intuitive: \code{"x"} and \code{"y"} are not orientations and their mapping to orientations is, in my
opinion, backwards; but the base ggplot naming scheme is allowed for compatibility).}

\item{interval_function}{Custom function for generating intervals (for most common use cases the \code{point_interval}
argument will be easier to use). This function takes a data frame of aesthetics and a \code{.width} parameter (a vector
of interval widths), and returns a data frame with
columns \code{.width} (from the \code{.width} vector), \code{.value} (point summary) and \code{.lower} and \code{.upper}
(endpoints of the intervals, given the \code{.width}). Output will be converted to the appropriate \code{x}- or
\code{y}-based aesthetics depending on the value of \code{orientation}. If \code{interval_function} is \code{NULL},
\code{point_interval} is used instead.}

\item{interval_args}{Additional arguments passed to \code{interval_function} or \code{point_interval}.}

\item{point_interval}{A function from the \code{\link[=point_interval]{point_interval()}} family (e.g., \code{median_qi},
\code{mean_qi}, etc). This function should take in a vector of value, and should obey the
\code{.width} and \code{.simple_names} parameters of \code{\link[=point_interval]{point_interval()}} functions, such that when given
a vector with \code{.simple_names = TRUE} should return a data frame with variables \code{.value}, \code{.lower},
\code{.upper}, and \code{.width}. Output will be converted to the appropriate \code{x}- or \code{y}-based aesthetics
depending on the value of \code{orientation}. See the \code{\link[=point_interval]{point_interval()}} family of functions for
more information.}

\item{.width}{The \code{.width} argument passed to \code{interval_function} or \code{point_interval}.}

\item{show_slab}{Should the slab portion of the geom be drawn? Default \code{TRUE}.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with a warning. If \code{TRUE}, missing
values are silently removed.}

\item{show.legend}{Should this layer be included in the legends? Default is \code{c(size = FALSE)}, unlike most geoms,
to match its common use cases. \code{FALSE} hides all legends, \code{TRUE} shows all legends, and \code{NA} shows only
those that are mapped (the default for most geoms).}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{.prob}{Deprecated. Use \code{.width} instead.}

\item{fun.data}{Deprecated. Use \code{point_interval} or \code{interval_function} instead.}

\item{fun.args}{Deprecated. Use \code{interval_args} instead.}
}
\value{
A \link[ggplot2:ggplot2-ggproto]{ggplot2::Stat} representing a point+multiple uncertainty interval geometry which can
be added to a \code{\link[=ggplot]{ggplot()}} object.
}
\description{
A combination of \code{\link[=stat_sample_slabinterval]{stat_sample_slabinterval()}} and
\code{\link[=geom_slabinterval]{geom_slabinterval()}} with sensible defaults.
While the corresponding \code{geom}s are intended for use on
data frames that have already been summarized using a \code{\link[=point_interval]{point_interval()}}
function, these \code{stat}s are intended for use directly on data frames of draws, and
will perform the summarization using a \code{\link[=point_interval]{point_interval()}} function.
}
\section{Aesthetics}{

These stats support the following aesthetics:
\itemize{
\item \code{datatype}
\item \code{x}
\item \code{y}
\item \code{thickness}
\item \code{size}
\item \code{group}
}
In addition, in their default configuration (paired with \code{\link[=geom_pointinterval]{geom_pointinterval()}}) the following aesthetics are supported by the underlying geom:
\itemize{
\item \code{x}
\item \code{y}
\item \code{datatype}
\item \code{alpha}
\item \code{colour}
\item \code{linetype}
\item \code{fill}
\item \code{shape}
\item \code{stroke}
\item \code{point_colour}
\item \code{point_fill}
\item \code{point_alpha}
\item \code{point_size}
\item \code{size}
\item \code{interval_colour}
\item \code{interval_alpha}
\item \code{interval_size}
\item \code{interval_linetype}
\item \code{slab_size}
\item \code{slab_colour}
\item \code{slab_fill}
\item \code{slab_alpha}
\item \code{slab_linetype}
\item \code{ymin}
\item \code{ymax}
\item \code{xmin}
\item \code{xmax}
\item \code{width}
\item \code{height}
\item \code{thickness}
\item \code{group}
}
See examples of some of these aesthetics in action in \code{vignette("slabinterval")}.
Learn more about the sub-geom aesthetics (like \code{interval_color}) in the \link[ggdist]{scales} documentation.
Learn more about basic ggplot aesthetics in \code{vignette("ggplot2-specs")}.
}

\examples{

library(dplyr)
library(ggplot2)

data(RankCorr_u_tau, package = "ggdist")

RankCorr_u_tau \%>\%
  ggplot(aes(y = factor(i), x = u_tau)) +
  stat_pointinterval(.width = c(.66, .95))

RankCorr_u_tau \%>\%
  ggplot(aes(x = factor(i), y = u_tau)) +
  stat_pointinterval(.width = c(.66, .95))

}
\seealso{
See \code{\link[=geom_pointinterval]{geom_pointinterval()}} for the geom versions, intended
for use on points and intervals that have already been summarized using a \code{\link[=point_interval]{point_interval()}} function.
See \code{\link[=stat_interval]{stat_interval()}} for a similar stat intended for intervals without
point summaries. See \code{\link[=stat_sample_slabinterval]{stat_sample_slabinterval()}} for a variety of other
stats that combine intervals with densities and CDFs.

See \code{\link[=geom_pointinterval]{geom_pointinterval()}} for the geom versions, intended
for use on points and intervals that have already been summarized using a \code{\link[=point_interval]{point_interval()}} function.
See \code{\link[=stat_interval]{stat_interval()}} for a similar stat intended for intervals without
point summaries.
See \code{\link[=stat_sample_slabinterval]{stat_sample_slabinterval()}} for a variety of other
stats that combine intervals with densities and CDFs.
See \code{\link[=geom_slabinterval]{geom_slabinterval()}} for the geom that these geoms wrap. All parameters of that geom are
available to these geoms.
}
