% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a_early.R
\name{as.geom}
\alias{as.geom}
\title{as.geom function}
\usage{
as.geom(x, ...)
}
\arguments{
\item{x}{a shape}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> Pass arguments to ggplot2::geom_point}
}
\value{
geom
}
\description{
Converts a ggdiagram shape to a ggplot2 geom
}
\details{
Usually the \code{as.geom} function is not necessary to call explicitly because it is called whenever a ggdiagram shape is added to a ggplot. However, in complex situations (e.g., making a function that assembles many objects), it is sometimes necessary to make the call explicitly.
}
\examples{
library(ggplot2)
c1 <- ob_circle(radius = 3)
ggplot() +
  as.geom(c1, fill = "black") +
  coord_equal()

}
