% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asymmetrise.R
\name{add_missing_combinations}
\alias{add_missing_combinations}
\title{Add missing combinations of x and y to a data frame}
\usage{
add_missing_combinations(.data, .x, .y)
}
\arguments{
\item{.data}{a data frame (or tibble) object}

\item{.x, .y}{column names to make combinations of}
}
\value{
a data frame (or tibble) with additional columns
}
\description{
Add rows to \code{.data} to complete all combinations of
    columns \code{.x} and \code{.y}. Importantly, this function observes and
    maintains any groups created by \code{dplyr::group_by()}.
}
\examples{
df <- data.frame(a = c("A", "B"),
                 b = c("C", "D"),
                 untouched = c(1, 2))
df

add_missing_combinations(df, a, b)

}
