% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transition_reveal.R
\name{transition_reveal}
\alias{transition_reveal}
\title{Reveal data along a given dimension}
\usage{
transition_reveal(along, range = NULL, keep_last = TRUE, id)
}
\arguments{
\item{along}{An unquoted expression giving the dimension to tween along. For
a gradually revealing time series this should be set to the same as the \code{x}
aesthetic.}

\item{range}{The time range to animate. If \code{NULL} it will be set to the range
of \code{along}}

\item{keep_last}{For non-path/polygon layers should the last row be kept for
subsequent frames.}

\item{id}{\strong{Deprecated}}
}
\description{
This transition allows you to let data gradually appear, based on a given
time dimension. In contrast to e.g. \code{\link[=transition_time]{transition_time()}} \code{transition_reveal()}
calculates intermediary values at exact positions instead of coercing raw
values into the closest frame. It further keeps old data for path and polygon
type layers so that they are gradually build up instead of being a set of
disconnected segments as will happen when using \code{\link[=transition_time]{transition_time()}} and
\code{\link[=shadow_mark]{shadow_mark()}} together.
}
\section{Label variables}{

\code{transition_along} makes the following variables available for string
literal interpretation, in addition to the general ones provided by
\code{\link[=animate]{animate()}}:
\itemize{
\item \strong{frame_along} gives the position on the along-dimension that the current
frame corresponds to
}
}

\section{Object permanence}{

\code{transition_reveal} uses the group aesthetic of each layer to identify
which rows in the input data correspond to the same graphic element and will
therefore define a a whole to be revealed over the animation.
The group aesthetic, if not set, will be calculated from the interaction of all
discrete aesthetics in the layer (excluding \code{label}), so it is often better
to set it explicetly when animating, to make sure your data is interpreted in
the right way. If the group aesthetic is not set, and no discrete aesthetics
exists then all rows will have the same group.
}

\section{Computed Variables}{

It is possible to use variables calculated by the statistic to define the
transition. Simply inclose the variable in \code{stat()} in the same way as when
using computed variables in aesthetics.
}

\examples{
anim <- ggplot(airquality, aes(Day, Temp, group = Month)) +
  geom_line() +
  transition_reveal(Day)

# Non-paths will only show the current position, not the history
anim1 <- ggplot(airquality, aes(Day, Temp, group = Month)) +
  geom_line() +
  geom_point(colour = 'red', size = 3) +
  transition_reveal(Day)

# Points can be kept by giving them a unique group and set `keep = TRUE` (the
# default)
anim2 <- ggplot(airquality, aes(Day, Temp, group = Month)) +
  geom_line() +
  geom_point(aes(group = seq_along(Day))) +
  geom_point(colour = 'red', size = 3) +
  transition_reveal(Day)

}
\seealso{
Other transitions: 
\code{\link{transition_components}()},
\code{\link{transition_events}()},
\code{\link{transition_filter}()},
\code{\link{transition_layers}()},
\code{\link{transition_manual}()},
\code{\link{transition_null}()},
\code{\link{transition_states}()},
\code{\link{transition_time}()}
}
\concept{transitions}
