% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_calendar_heatmap.R
\name{stat_calendar_heatmap}
\alias{stat_calendar_heatmap}
\title{Plots a calendar heatmap}
\usage{
stat_calendar_heatmap(mapping = NULL, data = NULL, show.legend = NA,
  inherit.aes = TRUE, na.rm = T, bandwidth = NULL, ...)
}
\arguments{
\item{mapping}{mapping}

\item{data}{df}

\item{show.legend}{logical}

\item{inherit.aes}{logical}

\item{na.rm}{logical}

\item{bandwidth}{bandwidth}

\item{...}{more functions}
}
\description{
A calendar heatmap provides context for weeks, and day of week and
is a better way to visualise daily data than line charts.
}
\section{Aesthetics}{
 date, fill.
}

\section{Data Tips}{
  \link[base]{strftime} can help extract the value
of the year, week of year, and day of week from the date column. You might
need to extract the year to facet multiple years as demonstrated in the
example.
This stat uses the following transformation to obtain the x and  y
coordinate to be used in the heatmap -
\code{
   data$x = 1 + as.integer(strftime(data$date, "\%W"))
   data$y = as.integer(strftime(data$date, "\%w"))
   data$y[data$y == 0L] = 7
   data$y = 8 - data$y
}
}

\section{Cosmetic Tips}{
 The minimalist look can be achieved by appending the
following chunk of code to the output object:
\code{
+
xlab(NULL) +
ylab(NULL) +
scale_fill_continuous(low = 'green', high = 'red') +
theme(
   axis.text = element_blank(),
   axis.ticks = element_blank(),
   legend.position = 'none',
   strip.background = element_blank(),
   panel.background = element_blank(),
   panel.border = element_blank()
)
}
}

\section{Also See}{
 \code{\link{ggplot_calendar_heatmap}}, a
polished but less flexible alternative.
}

\examples{
{
library(ggplot2)
DailyData = data.frame(
      DateCol = seq(
         as.Date("1/01/2014", "\%d/\%m/\%Y"),
         as.Date("31/12/2015", "\%d/\%m/\%Y"),
         "days"
      ),
      ValueCol = runif(730)
   )
   DailyData$Year = strftime(DailyData$DateCol, "\%Y")
ggplot(
   DailyData,
   aes(
      date = DateCol,
      fill = ValueCol
   )
) +
   stat_calendar_heatmap() +
   facet_wrap(~Year, ncol = 1)}
}
