% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/calc_roc.R
\name{calc_roc.rfsrc}
\alias{calc_roc}
\alias{calc_roc.randomForest}
\alias{calc_roc.rfsrc}
\title{Reciever Operator Characteristic calculator}
\usage{
calc_roc.rfsrc(object, yvar, which.outcome = "all", oob = TRUE)
}
\arguments{
\item{object}{\code{randomForestSRC::rfsrc} or \code{randomForestSRC::predict} object
containing predicted response}

\item{yvar}{True response variable}

\item{which.outcome}{If defined, only show ROC for this response.}

\item{oob}{Use OOB estimates, the normal validation method (TRUE)}
}
\value{
A \code{gg_roc} object
}
\description{
Reciever Operator Characteristic calculator
}
\details{
For a randomForestSRC prediction and the actual
response value, calculate the specificity (1-False Positive Rate) and sensitivity
(True Positive Rate) of a predictor.

This is a helper function for the \code{\link{gg_roc}} functions, and not intended
for use by the end user.
}
\examples{
## Taken from the gg_roc example
# rfsrc_iris <- rfsrc(Species ~ ., data = iris)
data(rfsrc_iris)
gg_dta <- calc_roc.rfsrc(rfsrc_iris, rfsrc_iris$yvar, which.outcome=1, oob=TRUE)
gg_dta <- calc_roc.rfsrc(rfsrc_iris, rfsrc_iris$yvar, which.outcome=1, oob=FALSE)
}
\seealso{
\code{\link{calc_auc}} \code{\link{gg_roc}} \code{\link{plot.gg_roc}}
}

