% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plot.gg_roc}
\alias{plot.gg_roc}
\title{ROC plot generic function for a \code{\link{gg_roc}} object.}
\usage{
\method{plot}{gg_roc}(x, which.outcome = NULL, ...)
}
\arguments{
\item{x}{\code{\link{gg_roc}} object created from a classification forest}

\item{which.outcome}{for multiclass problems, choose the class for plotting}

\item{...}{arguments passed to the \code{\link{gg_roc}} function}
}
\value{
\code{ggplot} object of the ROC curve
}
\description{
ROC plot generic function for a \code{\link{gg_roc}} object.
}
\examples{
\dontrun{
## ------------------------------------------------------------
## classification example
## ------------------------------------------------------------
#iris_rf <- rfsrc(Species ~ ., data = iris)
data(iris_rf, package="ggRandomForests")

# ROC for setosa
ggrf <- gg_roc(iris_rf, which.outcome=1)
plot.gg_roc(ggrf)

# ROC for versicolor
ggrf <- gg_roc(iris_rf, which.outcome=2)
plot.gg_roc(ggrf)

# ROC for virginica
ggrf <- gg_roc(iris_rf, which.outcome=3)
plot.gg_roc(ggrf)

# Alternatively, you can plot all three outcomes in one go
# by calling the plot function on the full forest.
plot.gg_roc(iris_rf)
}
}
\references{
Breiman L. (2001). Random forests, Machine Learning, 45:5-32.

Ishwaran H. and Kogalur U.B. (2007). Random survival forests for R,
Rnews, 7(2):25-31.

Ishwaran H. and Kogalur U.B. (2013). Random Forests for Survival,
Regression and Classification (RF-SRC), R package version 1.4.
}
\seealso{
\code{\link{gg_roc}} rfsrc
}

