% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmx-plots-density.R
\name{pmx_plot_iwres_dens}
\alias{pmx_plot_iwres_dens}
\title{IWRES density plot}
\usage{
pmx_plot_iwres_dens(ctr, dname, xlim, var_line, snd_line, vline, filter,
  strat.facet, facets, strat.color, trans, pmxgpar, labels, axis.title,
  axis.text, ranges, is.smooth, smooth, is.band, band, is.draft, draft,
  is.identity_line, identity_line, scale_x_log10, scale_y_log10,
  color.scales, ...)
}
\arguments{
\item{ctr}{pmx controller}

\item{dname}{\code{character} name of dataset to be used. User can create his own
dataset using \code{\link{set_data}} and pass it as dname to be plotted.}

\item{xlim}{\code{numeric} x axis limits}

\item{var_line}{\code{list} variable denstiy graphics parameters}

\item{snd_line}{\code{list} normal denstiy graphics parameters}

\item{vline}{\code{list} vertical line graphics parameters

\strong{pmx_update parameters}}

\item{filter}{\code{expression} filter which will be applied to plotting data.}

\item{strat.facet}{\code{formula} optional stratification parameter by facetting.
This split plot by strats(each strat in a facet)}

\item{facets}{\code{list} facet_wrap parameters.}

\item{strat.color}{\code{character} optional stratification parameter by grouping.
This will split the plot by group (color) of strat.}

\item{trans}{\code{character} define the transformation to apply on x or y or both variables}

\item{pmxgpar}{a object of class pmx_gpar possibly the output of the

\strong{pmx_gpar: Shared basic graphics parameters}}

\item{labels}{\code{list} list containing plot and/or axis labels: title, subtitle, x , y}

\item{axis.title}{\code{list} containing element_text attributes to customize
the axis title. (similar to ggplot2 axis.title theme)}

\item{axis.text}{\code{list} containing element_text attributes to customize
the axis text (similar to ggplot2 axis.text theme)}

\item{ranges}{\code{list} limits of x/y ranges}

\item{is.smooth}{\code{logical} if set to TRUE add smooth layer}

\item{smooth}{\code{list} geom_smooth graphical/smoothing fun parameters}

\item{is.band}{\code{logical} if TRUE add horizontal band}

\item{band}{\code{list} horizontal band parameters. geom_hline graphical parameters.}

\item{is.draft}{\code{logical} if TRUE add draft layer}

\item{draft}{\code{list} draft layer parameters. geom_text graphical parameters.}

\item{is.identity_line}{\code{logical} if TRUE add an identity line}

\item{identity_line}{\code{list}geom_abline graphical parameters.}

\item{scale_x_log10}{\code{logical} if TRUE use log10 scale for x axis.}

\item{scale_y_log10}{\code{logical} if TRUE use log10 scale for y axis.}

\item{color.scales}{\code{list} define scales parameter in case of strat.color \code{\link{pmx_settings}}}

\item{...}{others graphics parameters passed :
\itemize{
\item \code{\link{pmx_gpar}} internal function to customize shared graphical parameters
\item \code{\link{pmx_dens}} pmx density object.
\item \code{\link{pmx_update}} function.
}

\strong{pmx_dens parameters}}
}
\value{
ggplot2 or list of ggplot2 objects
}
\description{
IWRES density plot
}
