% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clip_shapefile.R
\name{clip_shapefile}
\alias{clip_shapefile}
\title{Clip a shapefile (SpatialPolygon) using a bounding area}
\usage{
clip_shapefile(
  x,
  limits,
  proj.limits = convert_crs(4326),
  simplify = FALSE,
  tol = 60,
  return.boundary = FALSE
)
}
\arguments{
\item{x}{Original shape file to be clipped as a an \link[sp]{sp} or \link[sf]{sf} polygons object. Required. Must contain \code{\link[sp:is.projected]{CRS}} information.}

\item{limits}{The constraining area used to clip \code{x}. Required. Either a numeric vector of length 4 or a \link[sp]{SpatialPolygons} object. The first element of the numeric vector defines the minimum longitude, second element the maximum longitude, third element the minimum latitude and fourth element the maximum latitude of the bounding box. The \link[sp]{SpatialPolygons} object must contain \code{\link[sp:is.projected]{CRS}} information. See details.}

\item{proj.limits}{The \code{\link[sp:is.projected]{CRS}} projection attributes for \code{limits} as character string (will be passed to \code{\link[sp]{CRS}}). Use the PROJ6 format. Defaults to decimal degrees (see Usage).}

\item{simplify}{Should the \code{x} geometry be simplified before clipping? Useful to make the function faster for large shape files. Uses \code{rgeos::gSimplify} function.}

\item{tol}{Numerical tolerance value to be used for simplification. See \code{?rgeos::gSimplify}.}

\item{return.boundary}{logical. If \code{TRUE} returns the clip boundary together with the shapefile}
}
\value{
Clipped \code{\link[sp]{SpatialPolygons}} object. If \code{return.boundary = TRUE}, a list containing the shapefile together with the clip boundary.
}
\description{
Clips an area from a larger shape file (\link[sp]{SpatialPolygons}).
}
\details{
The function uses the \code{rgeos::gIntersection} function to clip smaller \link[sp]{SpatialPolygons} from larger ones. The clip area is constrained by either a numeric vector or \link[sp]{SpatialPolygons} object in the \code{limits} argument. One of these arguments must be given. Defining \code{limits} by a \link[sp]{SpatialPolygons} object gives greater freedom for the clip area as the area does not have to be rectangular.
}
\seealso{
Other create shapefiles: 
\code{\link{geonorge_bathymetry}()},
\code{\link{raster_bathymetry}()},
\code{\link{vector_bathymetry}()}
}
\author{
Mikko Vihtakari with a solution from \href{https://stackoverflow.com/questions/15881455/how-to-clip-worldmap-with-polygon-in-r}{Simon O'Hanlon, Roger Bivand/SO community}
}
\concept{create shapefiles}
\keyword{internal}
