% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualise_single_sequence.R
\name{convert_input_seq_to_sequence_list}
\alias{convert_input_seq_to_sequence_list}
\title{Split a single input sequence into a vector of "lines" for visualisation (\code{\link[=visualise_single_sequence]{visualise_single_sequence()}} helper)}
\usage{
convert_input_seq_to_sequence_list(
  input_seq,
  line_length,
  spacing = 1,
  start_spaces = FALSE,
  end_spaces = FALSE
)
}
\arguments{
\item{input_seq}{\code{character}. A DNA/RNA sequence (or for the purposes of this function, any string, though only DNA/RNA will work with later functions) to be split up.}

\item{line_length}{\code{integer}. How long each line (split-up section) should be.}

\item{spacing}{\code{integer}. How many blank lines to leave before/after each line of sequence. Defaults to \code{0}.}

\item{start_spaces}{\code{logical}. Whether blank lines should also be present before the first line of sequence. Defaults to \code{FALSE}.}

\item{end_spaces}{\code{logical}. Whether blank lines should also be present after the last line of sequence. Defaults to \code{FALSE}.}
}
\value{
\verb{character vector}. The input sequence split into multiple lines, with specified spacing in between.
}
\description{
Takes a single input sequence and an integer line length, and splits the input
sequence into lines of that length (with the last line potentially being shorter). \cr\cr
Optionally inserts empty strings \code{""} after each line to space them out.
}
\examples{
convert_input_seq_to_sequence_list(
    "GGCGGCGGC",
    line_length = 6,
    spacing = 1,
    start_spaces = TRUE,
    end_spaces = TRUE
)

convert_input_seq_to_sequence_list(
    "GGCGGCGGC",
    line_length = 3,
    spacing = 2
)

convert_input_seq_to_sequence_list(
    "GGCGGCGGC",
    line_length = 3,
    spacing = 2,
    end_spaces = TRUE
)

convert_input_seq_to_sequence_list(
    "GGCGGCGGC",
    line_length = 6,
    spacing = 0,
    start_spaces = TRUE,
    end_spaces = FALSE
)

}
