% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3method.R
\name{plot.ICE}
\alias{plot.ICE}
\title{Plot method for ICE estimator objects}
\usage{
\method{plot}{ICE}(..., plot_obs = TRUE, label = 0)
}
\arguments{
\item{...}{ICE estimator objects.}

\item{plot_obs}{a logical value indicating whether to plot the observed risk over time.
Default is \code{TRUE}.}

\item{label}{a number specifying which time label is used in x-axis. 0 represents using generic numerical time index, and
1 represents using the original time label from the data. Default is 0.}
}
\value{
a plot for risks of all the interventions specified in \code{...}.
}
\description{
This function provides visualization of estimated risk 
for all specified interventions, estimated natural course risk, and observed risk at each time point.
}
\examples{

data <- gfoRmulaICE::compData

ice_fit1 <- ice(
data = data, 
time_points = 4, 
id = "id", 
time_name = "t0",
censor_name = "C", 
outcome_name = "Y",
compevent_name = "D",
comp_effect = 0,
outcome_model = Y ~ L1 + L2 + A1 + A2, 
censor_model = C ~ L1 + L2 + A1 + A2,
ref_idx = 0,
estimator = pool(hazard = FALSE),
int_descript = "Static Intervention",
intervention1.A1 = list(static(3)),
intervention1.A2 = list(static(1))
)

ice_fit2 <- ice(
data = data, 
time_points = 4, 
id = "id", 
time_name = "t0",
censor_name = "C", 
outcome_name = "Y",
compevent_name = "D",
comp_effect = 0,
outcome_model = Y ~ L1 + L2 + A1 + A2, 
censor_model = C ~ L1 + L2 + A1 + A2,
competing_model = D ~ L1 + L2 + A1 + A2,
ref_idx = 0,
estimator = pool(hazard = TRUE),
int_descript = "Static Intervention",
intervention1.A1 = list(static(3)),
intervention1.A2 = list(static(1))
)

plot(ice_fit1, ice_fit2)

}
