% Generated by roxygen2 (4.0.1): do not edit by hand
\name{plot_quantreg}
\alias{plot_quantreg}
\title{Linear Programming - Function for plotting results of bivariate quantile regression.}
\usage{
plot_quantreg(x, y, xlab = "x", ylab = "y", taus = c(0.05, 0.25, 0.5,
  0.75, 0.95))
}
\arguments{
\item{x}{Variable on the x-axis.}

\item{y}{Variable on the y-axis.}

\item{taus}{(optional) Quantiles for plotting, default is 'c(0.05,0.25,0.5,0.75,0.95)'.}

\item{xlab}{(optional)  Default is x.}

\item{ylab}{(optional)  Default is y.}
}
\description{
\code{plot_quantreg} Function for plotting results of bivariate quantile regression.
}
\examples{
data(baltimoreyouth)
x <- baltimoreyouth$teenbir10 # Teen births
y <- baltimoreyouth$compl10 # Highschool completion rate
plot_quantreg(x,y,xlab="Teen Births per 1000 Females (aged 15-19)",
     ylab="High School Completion Rates")
}
\author{
Jocelyn T. Chi
}

