% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_tb_burden.R
\name{map_tb_burden}
\alias{map_tb_burden}
\title{Map TB Burden}
\usage{
map_tb_burden(df = NULL, dict = NULL, metric = "e_inc_100k",
  metric_label = NULL, countries = NULL, compare_to_region = FALSE,
  facet = NULL, year = 2016, trans = "identity", interactive = FALSE,
  download_data = FALSE, save = FALSE, burden_save_name = "TB_burden",
  dict_save_name = "TB_data_dict", verbose = TRUE, ...)
}
\arguments{
\item{df}{Dataframe of TB burden data, as sourced by \code{\link[getTBinR]{get_tb_burden}}.
If not specified then will source the WHO TB burden data, either locally if available
or directly from the WHO (if \code{download_data = TRUE}).}

\item{dict}{A tibble of the data dictionary. See \code{\link[getTBinR]{get_data_dict}}
for details. If not supplied the function will attempt to load a saved version of the
dictionary. If this fails and \code{download_data = TRUE} then the dictionary will be downloaded.}

\item{metric}{Character string specifying the metric to plot}

\item{metric_label}{Character string specifying the metric label to use.}

\item{countries}{A character string specifying the countries to plot.}

\item{compare_to_region}{Logical, defaults to \code{FALSE}. If \code{TRUE} all
countries that share a region with those listed in \code{countries} will be plotted.
Note that this will override settings for \code{facet}, unless it is set to "country".}

\item{facet}{Character string, the name of the variable to facet by.}

\item{year}{Numeric, indicating the year of data to map. Defaults to 2016.}

\item{trans}{A character string specifying the transform to use on the mapped metric. Defaults to no
transform ("identity"). Other options include log scaling ("log") and log base 10 scaling
("log10"). For a complete list of options see \code{ggplot2::continous_scale}.}

\item{interactive}{Logical, defaults to \code{FALSE}. If \code{TRUE} then an interactive plot is
returned.}

\item{download_data}{Logical, defaults to \code{FALSE}. If not found locally should the data be
downloaded from the specified URL?}

\item{save}{Logical, should the data be saved for reuse during the current R session. Defaults to
\code{FALSE}. If \code{TRUE} then the data is saved to the temporary directory specified by \code{\link[base]{tempdir}}.}

\item{burden_save_name}{Character string, name to save the data under. Defaults to
\code{TB_burden}.}

\item{dict_save_name}{Character string, name to save dictionary under. Defaults to
\code{TB_data_dict}.}

\item{verbose}{Logical, defaults to \code{TRUE}. Should additional status and progress messages
be displayed.}

\item{...}{Additional parameters to pass to \code{\link[getTBinR]{get_tb_burden}}.}
}
\value{
A plot of TB Incidence Rates by Country
}
\description{
Map measures of TB burden by country by specifying a metric from the TB burden data.
Specify a country or vector of countries in order to map them (the default is to map all countries).
Various other options are available for tuning the plot further.
}
\examples{

## Map raw incidence rates
map_tb_burden(download_data = TRUE, save = TRUE)

## Map log scaled incidence rates
map_tb_burden(trans = "log")

## Find variables relating to mortality in the WHO dataset
search_data_dict(def = "mortality")

## Map mortality rates (exc HIV) - without progress messages
map_tb_burden(metric = "e_mort_exc_tbhiv_100k", verbose = FALSE)

}
\seealso{
plot_tb_burden plot_tb_burden_overview get_tb_burden search_data_dict
}
