% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SWATsubGage.R
\name{SWATsubGage}
\alias{SWATsubGage}
\title{Formats SWAT subbasin files to user specifications. Defaults support use of getSWATcfsr.}
\usage{
SWATsubGage(wd, outDir = "", numPars = 5, basinCentroid = FALSE)
}
\arguments{
\item{wd}{- String. location of the subbasin files to be formatted. Generally this is the TxtInOut folder generated when building a SWAT project.}

\item{outDir}{- String. The location to write the formatted subbasin files. By default, this is the same as the wd, and will overwrite exising subbasin files.}

\item{numPars}{- Integer. Number of measured weather parameters used in the model. Ranges from 1 to 5 with 1 as precipitation only, 2 as precipitation and temperature, 3 as precipitation, temperature, and solar radiation, 4 as precipitation, temperature, solar radiation, and relative humidity, and 5 as precipitaion, temperature, solar radiation, relative humididty, and wind speed. Default is 5, or all parameters are formatted as measured inputs.}

\item{basinCentroid}{- Logical. If TRUE, then all gage location flags are set to "1", meaning there is a single time series for each of the specified measured meterological inputs. Only use if a subbain center approximation of meteorological data is being used. Defaults to FALSE, or each subbasin has a corresponding time series in each measured meteorological input file.}
}
\value{
returns formatted subbasin files in the outDir location. If outDir is not specified files are saved to the wd location and any exising files are overwritten.
}
\description{
Formats SWAT subbasin files to user specifications. Defaults support use of getSWATcfsr.
}
\examples{
\dontrun{
SWATsubGaged(wd = '~/SWAT_PROJECT_FOLDER/TxtInOut')
}
}

