% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gest.R
\name{gest}
\alias{gest}
\title{G-Estimation for an End of Study Outcome}
\usage{
gest(
  data,
  idvar,
  timevar,
  Yn,
  An,
  Ybin,
  Abin,
  Lny,
  Lnp,
  type = 1,
  Cn = NA,
  LnC = NA,
  ...
)
}
\arguments{
\item{data}{A data frame in long format containing the data to be analysed. See description for details.}

\item{idvar}{Character string specifying the name of the ID variable in the data.}

\item{timevar}{Character string specifying the name of the time variable in the data.
Note that timevar must specify time periods as integer values starting from 1 (must not begin at 0).}

\item{Yn}{Character string specifying the name of the end of study outcome variable.}

\item{An}{Character string specifying the name of the time-varying exposure variable.}

\item{Ybin}{TRUE or FALSE indicator of whether the outcome is binary.}

\item{Abin}{TRUE or FALSE indicator of whether the exposure is binary.
Note that if \code{Abin==TRUE} then the variable specified in \code{An} MUST be written as a numeric variable.
taking values 0 or 1. If not use \code{\link{gestcat}}}

\item{Lny}{Vector of character strings specifying the names of the
time-varying and/or baseline confounders to be included in the outcome model in quotations.}

\item{Lnp}{Vector of character strings specifying the names of the time-varying and/or baseline confounders
to be included in the model calculating the propensity scores.}

\item{type}{Value from 1-4 specifying SNMM type to fit. See details.}

\item{Cn}{Optional character string specifying the name of the censoring indicator variable.
The variable specified in Cn should be a numeric variable taking values 0 or 1, with 1 indicating censored.}

\item{LnC}{Vector of character strings specifying the names of the time-varying and/or baseline covariates to be used in the censoring score model to calculate
the censoring weights. Note that any variable in \code{LnC} should also be in \code{Lnp} for the validity of the censoring and propensity weights.}

\item{...}{Additional arguments, currently not in use.}
}
\value{
List of the fitted causal parameters of the posited SNMM. These are labeled as follows for each SNMM type, where \code{An} is
set to the name of the exposure variable, i is the current time period, and \code{Lny[1]} is set to the name of the first confounder in \code{Lny}.
\item{\code{type=1} }{\code{An}: The effect of exposure at any time t on outcome. }
\item{\code{type=2} }{\code{An}: The effect of exposure at any time t on outcome, when \code{Ln[1]} is set to zero.\cr
\code{An:Ln[1]}: The effect modification by \code{Lny[1]}, the additional effect of A on Y for each unit increase in \code{Lny[1]}. }
\item{\code{type=3} }{\code{t=i.An}: The effect of exposure at time t=i on outcome.}
\item{\code{type=4} }{\code{t=i.An}: The effect of exposure at time t=i on outcome, when \code{Ln[1]} is set to zero.\cr
\code{t=i.An:Ln[1]}: The effect modification by \code{Lny[1]}, the additional effect of A on Y at time t=i for each unit increase in \code{Lny[1]}.}
}
\description{
Performs g-estimation of a structural nested mean model (SNMM), based on the outcome regression methods described
in Sjolander and Vansteelandt (2016) and Dukes and Vansteelandt (2018). We expect a dataset that holds an end of study outcome that is either binary or continuous,
time-varying and/or baseline confounders, and a time-varying exposure that is either binary or continuous.
}
\details{
Given a time-varying exposure variable, \eqn{A_t} and time-varying confounders, \eqn{L_t} measured over time periods \eqn{t=1,\ldots,T}, and an end of study outcome \eqn{Y}
measured at time \eqn{T+1}, \code{gest} estimates the causal parameters \eqn{\psi} of a SNMM of the form
 \deqn{E(Y(\bar{a}_{t},0)-Y(\bar{a}_{t-1},0)|\bar{a}_{t-1},\bar{l}_{t})=\psi z_ta_t \;\forall\; t=1,\ldots,T}
 if Y is continuous or
 \deqn{\frac{E(Y(\bar{a}_{t},0)|\bar{a}_{t-1},\bar{l}_{t})}{E(Y(\bar{a}_{t-1},0)|\bar{a}_{t-1},\bar{l}_{t})}=exp(\psi z_ta_t)\;\forall\; t=1,\ldots,T }
 if Y is binary. The SNMMs form is defined by the parameter \eqn{z_t}, which can be controlled by the input \code{type} as follows
 \itemize{
 \item{\code{type=1} }{sets \eqn{z_t=1}. This implies that \eqn{\psi} is the effect of exposure at any time t on Y.}
 \item{\code{type=2} }{sets \eqn{z_t=c(1,l_t)}, and adds affect modification by the first named variable in \code{Lny}, which we denote \eqn{L_t}.
 Now \eqn{\psi=c(\psi_0,\psi_1)} where \eqn{\psi_0} is the effect of exposure at any time t on Y when \eqn{l_t=0} for all t, modified by
 \eqn{\psi_1} for each unit increase in \eqn{l_t} at all times t. Note that effect modification
 is currently only supported for binary (written as a numeric 0,1 vector) or continuous confounders.}
 \item {\code{type=3} }{allows for time-varying causal effects. It sets \eqn{z_t} to a vector of zeros of length T with a 1 in the t'th position. Now \eqn{\psi=c(\psi_1,\ldots,\psi_T)}
 where \eqn{\psi_t} is the effect of \eqn{A_t} on Y.}
 \item{\code{type=4} }{allows for a time-varying causal effect that can be modified by the first named variable in \code{Lny}, that is it allows for both time-varying effects and effect modification. It sets \eqn{z_t} to a vector of zeros of length T with \eqn{c(1,l_t)} in the t'th position.
 Now \eqn{\psi=(\underline{\psi_1},\ldots,\underline{\psi_T})} where \eqn{\underline{\psi_t}=c(\psi_{0t},\psi_{1t})}. Here \eqn{\psi_{0t}} is the effect of exposure at time t on Y when \eqn{l_t=0} modified by
 \eqn{\psi_{1t}} for each unit increase in \eqn{l_t}. Note that effect modification
 is currently only supported for binary (written as a numeric 0,1 vector) or continuous confounders.}
 }
 The data must be in long format, where we assume the convention that each row with \code{time=t} contains \eqn{A_t,L_t} and \eqn{C_{t+1}} and \eqn{Y_{T+1}}. Thus the censoring indicator for each row
 should indicate that a user is censored AFTER time t. The end of study outcome \eqn{Y_{T+1}} should be repeated on each row. If either A or Y are binary, they must be written as numeric vectors taking values either 0 or 1.
 The same is true for any covariate that is used for effect modification.\cr
 The data must be rectangular with a row entry for every individual for each exposure time 1 up to T. Data rows after censoring should be empty apart from the ID and time variables. This can be done using the function \code{\link{FormatData}}.\cr
 By default the censoring, propensity and outcome models include the exposure history at the previous time as an explanatory variable. One may consider also including all previous exposure and confounder history as variables in \code{Lny},\code{Lnp}, and \code{LnC}, variables which can be generated using \code{\link{FormatData}}.\cr
 Censoring weights are handled as described in Sjolander and Vansteelandt (2016). Note that it is necessary that any variable included in \code{LnC} must also be in \code{Lnp}. Missing data not due to censoring are handled automatically by removing rows with missing data prior to fitting the model. If outcome models fail to fit, consider removing covariates from \code{Lny} but keeping
 them in \code{Lnp} to reduce collinearity issues.
}
\examples{
datas<-dataexamples(n=1000,seed=123,Censoring=FALSE)
data=datas$datagest
idvar="id"
timevar="time"
Yn="Y"
An="A"
Ybin=FALSE
Abin=TRUE
Lny=c("L","U")
Lnp=c("L","U")
type=1
Cn=NA
LnC=NA
gest(data,idvar=idvar,timevar,Yn,An,Ybin,Abin,Lny,Lnp,type=1)

#Example with censoring
datas<-dataexamples(n=1000,seed=123,Censoring=TRUE)
data=datas$datagest
Cn="C"
LnC=c("L","U")
gest(data,idvar,timevar,Yn,An,Ybin,Abin,Lny,Lnp,Cn,LnC,type=3)

}
\references{
Vansteelandt, S., & Sjolander, A. (2016). Revisiting g-estimation of the Effect of a Time-varying Exposure Subject to Time-varying Confounding, Epidemiologic Methods, 5(1), 37-56. <doi:10.1515/em-2015-0005>.

Dukes, O., & Vansteelandt, S. (2018). A Note on g-Estimation of Causal Risk Ratios, American Journal of Epidemiology, 187(5), 1079–1084. <doi:10.1093/aje/kwx347>.
}
