% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GermPercent.R
\name{GermPercent}
\alias{GermPercent}
\title{Germination percentage}
\usage{
GermPercent(germinated.seeds, germ.counts, total.seeds, partial = TRUE)
}
\arguments{
\item{germinated.seeds}{Number of germinated seeds}

\item{germ.counts}{Germination counts at each time interval. Can be partial
or cumulative as specified in the argument \code{partial}.}

\item{total.seeds}{Total number of seeds.}

\item{partial}{logical. If \code{TRUE}, \code{germ.counts} is considered as
partial and if \code{FALSE}, it is considered as cumulative. Default is
\code{TRUE}.}
}
\value{
The germination percentage (\%) value.
}
\description{
Compute the germination percentage or final germination percentage or
germinability.
}
\details{
Germination percentage is computed as follows
\insertCite{ista_chapter_2015}{germinationmetrics}. \loadmathjax

\mjsdeqn{GP = \frac{N_{g}}{N_{t}} \times 100}

Where, \mjseqn{N_{g}} is the number of germinated seeds and \mjseqn{N_{t}} is
the total number of seeds.

The value of \mjseqn{N_{g}} can be either specified using the argument
\code{germinated.seeds} or is computed from the \code{germ.counts} argument.
}
\examples{
x <- c(0, 0, 0, 0, 4, 17, 10, 7, 1, 0, 1, 0, 0, 0)
y <- c(0, 0, 0, 0, 4, 21, 31, 38, 39, 39, 40, 40, 40, 40)

# From partial germination counts
GermPercent(germ.counts = x, total.seeds = 50)

# From cumulative germination counts
GermPercent(germ.counts = y, total.seeds = 50, partial = FALSE)

# From number of germinated seeds
GermPercent(germinated.seeds = 40, total.seeds = 50)

}
\references{
\insertAllCited{}
}
